/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Font;
import java.awt.FontMetrics;
import java.io.CharConversionException;
import java.util.Hashtable;
import sun.awt.CharsetString;
import sun.awt.FontDescriptor;
import sun.awt.PlatformFont;
import sun.io.CharToByteConverter;

class X11FontMetrics
extends FontMetrics {
    int[] widths;
    int ascent;
    int descent;
    int leading;
    int height;
    int maxAscent;
    int maxDescent;
    int maxHeight;
    int maxAdvance;
    static Hashtable table = new Hashtable();

    public X11FontMetrics(Font font) {
        super(font);
        this.init();
    }

    public int getLeading() {
        return this.leading;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getHeight() {
        return this.height;
    }

    public int getMaxAscent() {
        return this.maxAscent;
    }

    public int getMaxDescent() {
        return this.maxDescent;
    }

    public int getMaxAdvance() {
        return this.maxAdvance;
    }

    public int stringWidth(String string) {
        return this.charsWidth(string.toCharArray(), 0, string.length());
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        Font font = this.getFont();
        PlatformFont platformFont = (PlatformFont)font.getPeer();
        if (platformFont.mightHaveMultiFontMetrics()) {
            return this.getMFStringWidth(cArray, n, n2, font, platformFont);
        }
        if (this.widths != null) {
            int n3 = 0;
            int n4 = n;
            while (n4 < n + n2) {
                char c = cArray[n4];
                n3 = c < '\u0000' || c >= this.widths.length ? (n3 += this.maxAdvance) : (n3 += this.widths[c]);
                ++n4;
            }
            return n3;
        }
        return this.maxAdvance * n2;
    }

    private int getMFStringWidth(char[] cArray, int n, int n2, Font font, PlatformFont platformFont) {
        int n3 = 0;
        CharsetString[] charsetStringArray = platformFont.makeMultiCharsetString(cArray, n, n2);
        int n4 = 0;
        int n5 = 0;
        while (n5 < charsetStringArray.length) {
            int n6 = charsetStringArray[n5].fontDescriptor.fontCharset.getMaxBytesPerChar() * charsetStringArray[n5].length;
            if (n4 < n6) {
                n4 = n6;
            }
            ++n5;
        }
        if (n4 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n4];
        int n7 = 0;
        while (n7 < charsetStringArray.length) {
            CharsetString charsetString = charsetStringArray[n7];
            try {
                CharToByteConverter charToByteConverter = (CharToByteConverter)charsetString.fontDescriptor.fontCharset.getClass().newInstance();
                int n8 = charToByteConverter.convert(charsetString.charsetChars, charsetString.offset, charsetString.offset + charsetString.length, byArray, 0, byArray.length);
                n3 += this.getMFCharSegmentWidth(font, charsetString.fontDescriptor, byArray, n8);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (CharConversionException charConversionException) {}
            ++n7;
        }
        return n3;
    }

    private native int getMFCharSegmentWidth(Font var1, FontDescriptor var2, byte[] var3, int var4);

    public native int bytesWidth(byte[] var1, int var2, int var3);

    public int[] getWidths() {
        return this.widths;
    }

    native void init();

    static synchronized FontMetrics getFontMetrics(Font font) {
        FontMetrics fontMetrics = (FontMetrics)table.get(font);
        if (fontMetrics == null) {
            fontMetrics = new X11FontMetrics(font);
            table.put(font, fontMetrics);
        }
        return fontMetrics;
    }
}

