/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import sun.misc.HexDumpEncoder;
import sun.security.util.BigInt;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgorithmId;

public class PKCS8Key
implements PrivateKey {
    protected AlgorithmId algid;
    protected byte[] key;
    private byte[] encodedKey;
    public static final BigInteger version = BigInteger.valueOf(0L);

    protected PKCS8Key() {
    }

    private PKCS8Key(AlgorithmId algorithmId, byte[] byArray) throws InvalidKeyException {
        this.algid = algorithmId;
        this.key = byArray;
        this.encode();
    }

    public static PKCS8Key parse(DerValue derValue) throws IOException {
        PKCS8Key pKCS8Key;
        if (derValue.tag != 48) {
            throw new IOException("corrupt private key");
        }
        BigInteger bigInteger = derValue.data.getInteger().toBigInteger();
        if (!version.equals(bigInteger)) {
            throw new IOException("version mismatch: (supported: " + version + ", parsed: " + bigInteger);
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValue.data.getDerValue());
        try {
            pKCS8Key = PKCS8Key.buildPKCS8Key(algorithmId, derValue.data.getOctetString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("corrupt private key");
        }
        if (derValue.data.available() != 0) {
            throw new IOException("excess private key");
        }
        return pKCS8Key;
    }

    protected void parseKeyBits() throws IOException, InvalidKeyException {
        this.encode();
    }

    static String getSunProperty(String string) {
        Provider provider = Security.getProvider("SUN");
        return provider.getProperty(string);
    }

    static PKCS8Key buildPKCS8Key(AlgorithmId algorithmId, byte[] byArray) throws IOException, InvalidKeyException {
        String string = PKCS8Key.getSunProperty("PrivateKey.PKCS#8." + algorithmId.getName());
        if (string == null) {
            string = "sun.security.x509.PKCS8Key";
        }
        try {
            Class clazz = Class.forName(string);
            Object object = clazz.newInstance();
            if (object instanceof PKCS8Key) {
                PKCS8Key pKCS8Key = (PKCS8Key)object;
                pKCS8Key.algid = algorithmId;
                pKCS8Key.key = byArray;
                pKCS8Key.parseKeyBits();
                return pKCS8Key;
            }
            System.err.println("Misconfiguration:  faulty key config, " + string);
            return new PKCS8Key(algorithmId, byArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Misconfiguration:  unknown key class, " + string);
            return new PKCS8Key(algorithmId, byArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new IOException(String.valueOf(string) + " [internal error]");
        }
        catch (InstantiationException instantiationException) {
            System.err.println("Misconfiguration:  faulty key class, " + string);
            return new PKCS8Key(algorithmId, byArray);
        }
    }

    public String getAlgorithm() {
        return this.algid.getName();
    }

    public AlgorithmId getAlgorithmId() {
        return this.algid;
    }

    public final void emit(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(new BigInt(version.toByteArray()));
        this.algid.emit(derOutputStream2);
        derOutputStream2.putOctetString(this.key);
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public synchronized byte[] getEncoded() {
        block2: {
            if (this.encodedKey != null) break block2;
            try {
                this.encode();
            }
            catch (InvalidKeyException invalidKeyException) {}
        }
        return this.encodedKey;
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public byte[] encode() throws InvalidKeyException {
        if (this.encodedKey == null) {
            try {
                DerOutputStream derOutputStream = new DerOutputStream();
                this.emit(derOutputStream);
                this.encodedKey = derOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new InvalidKeyException("IOException : " + iOException.getMessage());
            }
        }
        return this.encodedKey;
    }

    public String toString() {
        HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
        return "algorithm = " + this.algid.toString() + ", unparsed keybits = \n" + hexDumpEncoder.encodeBuffer(this.key);
    }

    public void decode(InputStream inputStream) throws InvalidKeyException {
        try {
            DerValue derValue = new DerValue(inputStream);
            if (derValue.tag != 48) {
                throw new InvalidKeyException("invalid key format");
            }
            BigInteger bigInteger = derValue.data.getInteger().toBigInteger();
            if (!bigInteger.equals(version)) {
                throw new IOException("version mismatch: (supported: " + version + ", parsed: " + bigInteger);
            }
            this.algid = AlgorithmId.parse(derValue.data.getDerValue());
            this.key = derValue.data.getOctetString();
            this.parseKeyBits();
            if (derValue.data.available() != 0) {
                throw new InvalidKeyException("excess key data");
            }
        }
        catch (IOException iOException) {
            throw new InvalidKeyException();
        }
    }

    public void decode(byte[] byArray) throws InvalidKeyException {
        this.decode(new ByteArrayInputStream(byArray));
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getEncoded());
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.decode(objectInputStream);
            return;
        }
        catch (InvalidKeyException invalidKeyException) {
            invalidKeyException.printStackTrace();
            throw new IOException("deserialized key is invalid: " + invalidKeyException.getMessage());
        }
    }
}

