/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import java.security.interfaces.DSAParams;
import sun.security.pkcs.PKCS8Key;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.x509.AlgIdDSA;

public final class DSAPrivateKey
extends PKCS8Key
implements java.security.interfaces.DSAPrivateKey,
Serializable {
    private BigInteger x;

    public DSAPrivateKey() {
    }

    public DSAPrivateKey(byte[] byArray) throws InvalidKeyException {
        this.decode(byArray);
    }

    public DSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        this.algid = new AlgIdDSA(bigInteger2, bigInteger3, bigInteger4);
        try {
            this.key = new DerValue(2, bigInteger.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException iOException) {
            throw new InvalidKeyException("counld not DER encode y: " + iOException.getMessage());
        }
        this.x = bigInteger;
    }

    public DSAParams getParams() {
        try {
            if (this.algid instanceof DSAParams) {
                return (DSAParams)((Object)this.algid);
            }
            byte[] byArray = this.algid.encode();
            this.algid = new AlgIdDSA(byArray);
            return (DSAParams)((Object)this.algid);
        }
        catch (IOException iOException) {
            throw new ProviderException("unable to parse algorithm params.");
        }
    }

    public BigInteger getX() {
        return this.x;
    }

    protected void parseKeyBits() throws InvalidKeyException {
        DerInputStream derInputStream = new DerInputStream(this.key);
        try {
            this.x = derInputStream.getInteger().toBigInteger();
            return;
        }
        catch (IOException iOException) {
            throw new InvalidKeyException(iOException.getMessage());
        }
    }

    byte[] getEncodedKey() throws InvalidKeyException {
        return this.getEncoded();
    }

    public String toString() {
        return "Sun DSA Private Key \nparameters:" + this.algid + "\nx: " + this.x.toString(16) + "\n";
    }
}

