(* FileSys.i3
|  ----------

Carsten Weich, Sep. 1993

Interface to the System Module used mainly on the PC.
Used by ls and m3shell
******************************************************************)

INTERFACE FileSys;

    IMPORT List, System;

    PROCEDURE Caps (t: TEXT): TEXT;
        (* Change to all lower-case letters *)

    PROCEDURE ChangeToRegExpr (name: TEXT): TEXT;
        (* Replace the shell-like wildcards to regular-expression 
           equivalents *)

    PROCEDURE ChangeBackslash (t: TEXT): TEXT;
    PROCEDURE ChangeSlash (t: TEXT): TEXT;
	    (* Replaces all Backslashes \ to Slashes / and vice versa *)

    PROCEDURE GetDirList (path := "."; expr := ".*"): List.T
		RAISES {System.Error};
        (* Scanning one directory *)

END FileSys.
