(*

	System
	------

Weich, August 1993

Interface to unsave Unixcalls. This is made to encapsulate the UNSAVE
calls from the applications. Unixcalls are shortened.

This is the PC-version. Filenames are all long names. Never use
directory-names longer than 8 characters (see NameMap.i3).
*****************************************************************************)


INTERFACE System;

    IMPORT Time;

    EXCEPTION Error(TEXT);

    PROCEDURE Exit(code: INTEGER);
	(* Interface to exit(3) *)

    PROCEDURE CallProg (command: TEXT) RAISES {Error};
	(* Interface to system(3), see Unix.i3 *)

    PROCEDURE GetHostname(): TEXT RAISES {Error};
	(* Returns "PC" always *)

    PROCEDURE TimeToText(t: Time.T): TEXT;
	(* Convert a time-value to a text similar to that of ls-listings *)

(******************************************)
(* Unix-Processes (meaningless on the PC) *)
(******************************************)
    TYPE PID = INTEGER;

    PROCEDURE GetPID(): PID RAISES {Error};
	(* Interface zu getpid(2) *)
    PROCEDURE TestPID(pid: PID): BOOLEAN RAISES {Error};
	(* Retourniert TRUE, wenn pid ein laufender Prozess ist, *)
	(* sonst FALSE. (Sendet ein 0 Signal: kill(pid, 0) ) *)

(****************************)
(*    Regular-Expression    *)
(****************************)
    PROCEDURE TestRegExpr (testString, muster: TEXT): BOOLEAN  RAISES {Error};
	(* Retourniert TRUE, wenn 'testString' die "regular Expression
	   'muster' enthlt; FALSE sonst, auch dann, wenn 'Muster' keine
	    gltige Expression ist. 
|          Wird mit regcmp(3X) und regex(3X) implementiert. Siehe Manuals
	    fr Details ber erlaubte Expressions. *)

(*************************)
(* Directories Lesen *)
(*************************)
    TYPE Dir <: REFANY;

    PROCEDURE GetCurrentDir(): TEXT;
    PROCEDURE ChangeDir(path: TEXT) RAISES {Error};
	(* Current working directory wechseln. *)

    PROCEDURE OpenDir (path: TEXT; fileSelection:= ".*"): Dir RAISES {Error};
    PROCEDURE GetnextDirentry(dir: Dir): TEXT   RAISES {Error};
    PROCEDURE CloseDir(dir: Dir) RAISES {Error};
	(* Directory lesen, siehe auch Udir.i3!
|         Mit OpenDir kann eine Maske gesetzt werden: GetnextDirentry()
	   Testet alle Dateinamen des Directories mit TestRegExpr(), nur
	   die die entsprechen, werden retourniert. GetnextDirentry retourniert
	   NIL, wenn es nichts mehr gibt. *)
    PROCEDURE SeekDirentry(dir: Dir; pos: CARDINAL): TEXT   RAISES {Error};
	(* This is unique for the DOS interface: Because of some DOS limitations
	   on having more than one directory open, it is sometimes necessary
	   to open it, seek the next position manually, and close it. 
	   The value of fileSelection is meaningless for this call. *)

    PROCEDURE FileIsReadable(path: TEXT): BOOLEAN;
    PROCEDURE FileIsWriteable(path: TEXT): BOOLEAN;
    PROCEDURE FileIsExecutable(path: TEXT): BOOLEAN;
    PROCEDURE FileIsDirectory(path: TEXT): BOOLEAN;
	(* Informationen mit Filenamen abfragen (Interface zu access(2)
	   stat(2) ). Gibt es ein solches File berhaupt nicht, dann ist der
	   returnwert ebenfalls FALSE. *)

    PROCEDURE FileModifyTime(path: TEXT): Time.T RAISES {Error};
    PROCEDURE FileSize(path: TEXT): CARDINAL RAISES {Error};
	(* Fr letzte Modifikation und Gre einer Datei. Existiert sie nicht,
	   dann gibt es die Exception. FileModifyTimeString() liefert einen
	   String fr Directorylistings. *)
END System.
