(*
	m3shell

Weich, Aug. 1993

For description see m3shell.tex!
To customize change the constants to reasonable values and recompile!

Modified by Jerney, Feb. 1994
******************************************************************************)

MODULE m3shell EXPORTS Main;

IMPORT MyFile, FileSys, System, Filename, FileStream, NameMap, 
	   Modules, ProgFileIO, Time, Fmt, Char, List, Stdio, Wr, Rd, Thread,
	   Text, DosIO, Terminal, ErrList, SF, SIO, trc;

<*FATAL Wr.Failure, Rd.Failure, Thread.Alerted*>

CONST
    MaxSpalten = 10;                            (* max columns for ls command *)
    SchirmBreite = 80;                          (* screenwidth *)
    HOME = "/users/carsten";                    (* this is where cd without
						   a dirname switches to *)
(* for the make-command *)
	PgmListFile = ".pgms";                  (* file to write the list of
												   programs in *)
    Includestring = "-D/m3/local/include ";     (* public interfaces as run-
												   parameter to m3 *)
    Libstring = "-lm3loc -lgpl ";               (* libraries as par. to m3 *)
    SourcePath = ".";                           (* dirs for m3-sources *)
    PublicPath = "/m3/include:/m3/local/include";(* public interfaces*)

PROCEDURE Error (message: TEXT) =
    BEGIN
	Wr.Flush(Stdio.stdout);
	Wr.PutText(Stdio.stderr, "m3shell: " & message & "\n");
	Wr.Flush(Stdio.stderr);
    END Error;

PROCEDURE Message (message: TEXT) =
	BEGIN
	Wr.PutText(Stdio.stdout, message & "\n");
	Wr.Flush(Stdio.stdout);
    END Message;

PROCEDURE HelpMessage () =
	BEGIN
		Message("List of m3shell-Commands:");
		Message("");
		Message("ls [-la] [Filename ..] [Dir.name ..]...........................Directorylisting");
		Message("pwd.............................................Print current working directory");
		Message("m3mapentry LongFilename [..]..........................New entry in the name map");
		Message("m3delmapentry LongFilename [..]..................Delete entry from the name map");
		Message("lon.................................Compilerlisting is generated without errors");
		Message("loff.....................Only in case of errors an Compilerlisting is generated");
		Message("won...................................No warnings are generated by the compiler");
		Message("woff.....................................Warnings are generated by the compiler");
		Message("make [-deb] MainModuleName...........................Compile and link a program");
		Message("help............................................................Print this list");
		Message("exit..........................................................Terminate m3shell");
	END HelpMessage;



(* Procedures for the formating*)

PROCEDURE Header (dirname: TEXT) =
    BEGIN
	Wr.PutText(Stdio.stdout, dirname & "\n\n");
	Wr.Flush(Stdio.stdout);
    END Header;

PROCEDURE FormatEntry (dir, entry: TEXT; longMode: BOOLEAN): TEXT
    RAISES {System.Error} =
    VAR
	file := dir & "/" & entry;
	l: TEXT;
    BEGIN
	IF longMode THEN
	    IF System.FileIsDirectory(file) THEN
		l := "d"
	    ELSE
		l := "-"
	    END;
	    IF System.FileIsReadable(file) THEN
		l := l & "r"
	    ELSE
		l := l & "-"
	    END;
	    IF System.FileIsWriteable(file) THEN
		l := l & "w"
	    ELSE
		l := l & "-"
	    END;
	    IF System.FileIsExecutable(file) THEN
		l := l & "x"
	    ELSE
		l := l & "-"
	    END;
	    l := l & "  " & Fmt.F("%8s", Fmt.Int(System.FileSize(file)));
	    l := l & "  " & System.TimeToText(System.FileModifyTime(file));
	    l := l & "  " & entry;
	ELSE
	    l := entry
	END;
	RETURN l;
    END FormatEntry;

PROCEDURE WrDirList (path: TEXT; dir: List.T; longMode: BOOLEAN)
    RAISES {System.Error} =
    VAR
	anzSpalten, anzZeilen: CARDINAL;
	anzFiles := List.Length(dir);
	maxNameLen:= 0;
	totalSize:= 0;
		entry: TEXT;

    PROCEDURE CompareEntries (<*UNUSED*> arg: REFANY; item1, item2: REFANY):
	[-1 .. 1] =
	(* compare independent of upper/lower-case, set maxNameLen *)
	VAR
	    len1:= Text.Length(item1);
	    len2:= Text.Length(item2);
	BEGIN
	    IF len1 > maxNameLen THEN maxNameLen:= len1 END;
	    IF len2 > maxNameLen THEN maxNameLen:= len2 END;
	    RETURN Text.Compare(FileSys.Caps(item1), FileSys.Caps(item2));
	END CompareEntries;

    BEGIN
	dir := List.Sort(dir, c := CompareEntries);
	IF NOT Text.Equal(path, ".") THEN Header(path) END;
	anzSpalten := SchirmBreite DIV (maxNameLen + 2);
	IF anzSpalten > anzFiles THEN anzSpalten := anzFiles END;
	IF anzSpalten > MaxSpalten THEN anzSpalten := MaxSpalten END;
	IF longMode THEN anzSpalten := 1 END;
	anzZeilen := anzFiles DIV anzSpalten;
	IF anzFiles MOD anzSpalten # 0 THEN INC(anzZeilen) END;
	FOR z := 0 TO anzZeilen - 1 DO
	    FOR s := 0 TO anzSpalten - 1 DO
		WITH elm = z + s * anzZeilen DO
		    IF elm < anzFiles THEN
						entry:= List.Nth(dir, elm);
						IF longMode THEN
							totalSize:= totalSize +
								System.FileSize(NameMap.GetDos(path&"/"&entry));
						END;
			Wr.PutText(
			    Stdio.stdout,
			    Fmt.F("%-" & Fmt.Int(maxNameLen) & "s  ",
				  FormatEntry(path, entry, longMode) ));
		    END;
		END;
	    END;
	    Wr.PutText(Stdio.stdout, "\n");
	END;
	IF longMode THEN
	    Wr.PutText(Stdio.stdout,
		       "total:  " & Fmt.Int(totalSize) & " bytes in "
			   & Fmt.Int(anzFiles) & " files\n");
	END;
	Wr.Flush(Stdio.stdout);
    END WrDirList;

PROCEDURE DeleteHidden (VAR dirs: List.T) =
    BEGIN
	IF dirs # NIL THEN
	    IF Text.GetChar(dirs.first, 0) = '.' THEN
		dirs := dirs.tail;
		DeleteHidden(dirs);
	    ELSE
		DeleteHidden(dirs.tail);
	    END;
	END;
    END DeleteHidden;

PROCEDURE ListDir (params: ARRAY OF TEXT) =
    VAR
	start := FIRST(params);
	expr := ".*";
	dirpath := ".";
	name: TEXT;
	dirlist: List.T;
	longMode, allMode:= FALSE;
    BEGIN
	TRY
	    IF NUMBER(params) > 0 THEN
		IF Text.Equal(params[FIRST(params)], "-l") THEN
		    start := FIRST(params)+1;
		    longMode := TRUE;
		ELSIF Text.Equal(params[FIRST(params)], "-a") THEN
		    start := FIRST(params)+1;
		    allMode := TRUE;
		ELSIF Text.Equal(params[FIRST(params)], "-la")
			  OR Text.Equal(params[0], "-al") THEN
		    start := FIRST(params)+1;
		    longMode := TRUE;
		    allMode := TRUE;
		END;
	    END;
	    IF start > LAST(params) THEN
		dirlist := FileSys.GetDirList();
		IF NOT allMode THEN DeleteHidden(dirlist) END;
		IF List.Length(dirlist) > 0 THEN
		    WrDirList(dirpath, dirlist, longMode);
		END;
	    END;
	    FOR i := start TO LAST(params) DO
		name := params[i];
		IF Text.GetChar(name, 0) # '*' (* Bug in FileIsDir. *) AND 
		   System.FileIsDirectory(name)
		THEN
		    dirpath := name;
		    expr := ".*";
		ELSIF Text.FindChar(name, '/') >= 0 THEN
		    dirpath := Filename.Head(name);
		    expr := FileSys.ChangeToRegExpr(Filename.Tail(name));
		ELSE
		    dirpath := ".";
		    expr := FileSys.ChangeToRegExpr(name);
		END;
		IF NOT System.FileIsDirectory(dirpath) THEN
		    Error(dirpath & ": not a directory");
		ELSE
		    dirlist := FileSys.GetDirList(dirpath, expr);
		    IF NOT allMode THEN DeleteHidden(dirlist) END;
		    IF List.Length(dirlist) = 0 THEN
			Error(name & ": no such file or directory")
		    ELSE
			WrDirList(dirpath, dirlist, longMode);
		    END;
		END;
	    END;
	EXCEPT
	  System.Error (text) => Error(text);
	END;
    END ListDir;


(* Compile a Programm *)
(*--------------------*)

PROCEDURE CompileModules (rootName: TEXT;pp:BOOLEAN;nl:[1..2]) =
	(* This is a short version of emake *)
	VAR
	modules := NEW(Modules.T);
	command := "m3 -why -w" & warn_level & " -make " &
		   Includestring & Libstring;
	modName, aoutName: TEXT;
	aoutUpdate: Time.T;
	pgmList: Wr.T;
    BEGIN
		(* Search the modules *)
	modules.sourcePath := SourcePath;
	modules.publicPath := PublicPath;
	modules.searchMode := FALSE;
		TRY
	    modules.getModules(rootName);
		EXCEPT
		    Modules.NotFound, System.Error,
			ProgFileIO.SyntaxError (ErrorText) => Error(ErrorText); RETURN;
		 |  Rd.EndOfFile=> Error("Unexpected EOF reached in a module"); RETURN;
		END;

	modules.beginScann();
	modName := modules.next();
	aoutName := Modules.Basename(modName);

	(* Monitor, if compilation was successfull: *)
	TRY
	    aoutUpdate := System.FileModifyTime(aoutName);
	EXCEPT
	  System.Error => aoutUpdate := Time.Epoch;
	END;

	(* put the compiler-commandstring together: *)
	command := command & " -o " & aoutName & " ";
		pgmList := FileStream.OpenWrite(PgmListFile);
		WHILE modName # NIL DO
			IF NOT modules.publicInterface() THEN
				Wr.PutText(pgmList, modName & "\n");
			END;             (*IF*)
			modName := modules.next();
		END;                 (*WHILE*)
		Wr.Close(pgmList);
		command := command & " -F" & PgmListFile;
	Message(command);
		TRY
		IF pp THEN
		  modules.beginScann();
		  modName:=modules.next();
		  WHILE modName#NIL DO
		    IF Text.Equal(Modules.Extname(modName),"m3") THEN
		      System.CallProg(FileSys.ChangeSlash("copy "&modName&
		      " c:/tmp > nul"));
		      (* Preprocessing module. *)  
		      trc.pp(modName, FileSys.ChangeSlash("c:/tmp/"&
		      Text.Sub(modName,Text.FindCharR(modName,'/')+1,
		      Text.Length(modName)-Text.FindCharR(modName,'/')))); 
		    END; (* IF *)
		    modName:=modules.next();
		  END; (* WHILE *)
		END; (* IF *)
		System.CallProg(command&FileSys.ChangeSlash(" > c:/tmp/error.lst"));
		System.CallProg(FileSys.ChangeSlash("type c:/tmp/error.lst"));
		IF pp THEN
		  modules.beginScann();
		  modName:=modules.next();
		  WHILE modName#NIL DO
		    IF Text.Equal(Modules.Extname(modName),"m3") THEN
		      System.CallProg(FileSys.ChangeSlash("copy c:/tmp/"&
		      Text.Sub(modName,Text.FindCharR(modName,'/')+1,
		      Text.Length(modName)-Text.FindCharR(modName,'/'))&
		      " "&modName&" > nul"));
		      System.CallProg(FileSys.ChangeSlash("del c:/tmp/"&
		      Text.Sub(modName,Text.FindCharR(modName,'/')+1,
		      Text.Length(modName)-Text.FindCharR(modName,'/'))));
		      IF SF.FileExists(Text.Sub(modName,0,
			 Text.Length(modName)-2)&"mo") THEN
			System.CallProg(FileSys.ChangeSlash("del "&
			Text.Sub(modName,0,Text.Length(modName)-2)&"mo"));
		      END; (* IF *)
		    END; (* IF *)
		    modName:=modules.next();
		  END; (* WHILE *)
		END; (* IF *)
		ErrList.mkerrlist(FileSys.ChangeSlash("c:/tmp/error.lst"), nl);
		NameMap.RereadNameMap();
		EXCEPT
			System.Error=> Error("FATAL: can't start the compiler"); RETURN;
		 |  Rd.Failure=> Error("FATAL: namemap-failure!"); RETURN;
		END;
	TRY
	    IF Time.Compare(aoutUpdate, System.FileModifyTime(aoutName)) < 1
			THEN
		Message("converting to " & aoutName & ".exe\n");
		System.CallProg("aout2exe " & aoutName);
		System.CallProg("del " & aoutName);
	    END;
	EXCEPT
	  System.Error => Error("no new program\n");
	END;
    END CompileModules;


(* Convert a Command to an ARRAY OF Parameter *)
(*--------------------------------------------*)

PROCEDURE ParseCommand (cmd: TEXT): REF ARRAY OF TEXT =
    CONST MaxPars = 127;
    VAR
	WhiteSpaces:= Fmt.Char(' ')&Fmt.Char(Char.HT);
	Nul:= Fmt.Char(Char.NUL);
	i := 0;
	j := 0;
	n: INTEGER;
	cmdchars: ARRAY [0 .. 1023] OF CHAR;
		par: TEXT;
	params: ARRAY [0 .. MaxPars] OF TEXT;
	result: REF ARRAY OF TEXT;
    BEGIN
	Text.SetChars(cmdchars, cmd & Nul);
	LOOP
	    WHILE Text.FindChar(WhiteSpaces, cmdchars[i])>=0 DO INC(i) END;
	    IF i >= Text.Length(cmd) THEN EXIT END;
	    n := 0;
	    WHILE Text.FindChar(WhiteSpaces&Nul, cmdchars[i+n])<0 DO
		INC(n)
	    END;
			par:= Text.Sub(cmd, i,n);
			IF Text.GetChar(par, Text.Length(par)-1) # '/' THEN
				(* don't look up directories and single slashes *)
				par:= NameMap.GetDos(par);
			END;
	    params[j] := par;
	    INC(i, n);
	    IF j = MaxPars THEN EXIT ELSE INC(j) END;
	END;
	result := NEW(REF ARRAY OF TEXT, j);
	result^ := SUBARRAY(params, 0, j);
	RETURN result;
    END ParseCommand;

 
PROCEDURE GetCmdLine(VAR line:TEXT; VAR hist:ARRAY OF TEXT)=
(* Reads the input from the keyboard. *)

VAR asccode, row, col, llength, i, histptr:INTEGER;
    procline:=ARRAY [0..maxcmdlength-1] OF CHAR {Char.NUL,..};
    procptr:REF ARRAY OF CHAR;
    

PROCEDURE InsertCmd(line:TEXT; VAR hist:ARRAY OF TEXT)=
(* Inserts line in hist(orylist). *)

BEGIN (* InsertCmd *)
  FOR i:=LAST(hist)-1 TO FIRST(hist) BY -1 DO
    hist[i+1]:=hist[i];
  END; (* FOR *)
  hist[FIRST(hist)]:=line;
END InsertCmd;


BEGIN (* GetCmdLine *)
  histptr:=-1;
  procptr:=NEW(REF ARRAY OF CHAR, maxcmdlength);
  procptr^:=procline;
  line:="";
  llength:=0;
  asccode:=DosIO.getxkey();
  WHILE asccode#13 DO
    IF asccode=587 OR asccode=8 THEN
      (* Move Cursor left and delete written characters. *)
      DosIO.ScreenGetCursor(row, col);
      IF (llength>0) THEN
	DEC(col);
	DEC(llength);
	procptr^[llength]:=Char.NUL;
	IF col<0 THEN
	  DosIO.ScreenSetCursor(row-1,maxcols-1);  
	ELSE
	  DosIO.ScreenSetCursor(row, col);             
	END; (* IF *)      
	SIO.PutChar(' ',Stdio.stdout); 
	Wr.Flush(Stdio.stdout);
	IF col<0 THEN
	  DosIO.ScreenSetCursor(row-1,maxcols-1);        
	ELSE
	  DosIO.ScreenSetCursor(row, col);  
	END; (* IF *)      
      END; (* IF *)
    ELSIF asccode>=28 AND asccode<=200 THEN  (* Character is a printable. *)
      IF llength<maxcmdlength THEN
	Terminal.PutText(Fmt.Char(VAL(asccode,CHAR)));
	procptr^[llength]:=VAL(asccode,CHAR);
	INC(llength);    
      END; (* IF *)
    ELSIF asccode=584 THEN (* Back in history list. *)
      IF histptr<HistSize THEN  
	WHILE llength>0 DO (* Delete written Command on Screen. *)     
	  DosIO.ScreenGetCursor(row, col);    
	  DEC(col);
	  DEC(llength);
	  procptr^[llength]:=Char.NUL;
	  IF col<0 THEN
	    DosIO.ScreenSetCursor(row-1,maxcols-1);  
	  ELSE
	    DosIO.ScreenSetCursor(row, col);             
	  END; (* IF *)      
	  SIO.PutChar(' ',Stdio.stdout); 
	  Wr.Flush(Stdio.stdout);
	  IF col<0 THEN
	    DosIO.ScreenSetCursor(row-1,maxcols-1);        
	  ELSE
	    DosIO.ScreenSetCursor(row, col);  
	  END; (* IF *)
	END; (* WHILE *)
	procptr^:=procline;
	INC(histptr);  
	FOR i:=0 TO Text.Length(hist[histptr])-1 DO
	  procptr^[i]:=Text.GetChar(hist[histptr],i);      
	END; (* FOR *)
	llength:=Text.Length(hist[histptr]);
	Terminal.PutText(hist[histptr]);
      END; (* IF *)
    ELSIF asccode=592 THEN (* Forward in history list. *) 
      IF histptr>0 THEN   
	WHILE llength>0 DO (* Delete written Command on Screen. *)     
	  DosIO.ScreenGetCursor(row, col);    
	  DEC(col);
	  DEC(llength);
	  procptr^[llength]:=Char.NUL;
	  IF col<0 THEN
	    DosIO.ScreenSetCursor(row-1,maxcols-1);  
	  ELSE
	    DosIO.ScreenSetCursor(row, col);             
	  END; (* IF *)      
	  SIO.PutChar(' ',Stdio.stdout); 
	  Wr.Flush(Stdio.stdout);
	  IF col<0 THEN
	    DosIO.ScreenSetCursor(row-1,maxcols-1);        
	  ELSE
	    DosIO.ScreenSetCursor(row, col);  
	  END; (* IF *)
	END; (* WHILE *)
	procptr^:=procline;   
	DEC(histptr);                  
	FOR i:=0 TO Text.Length(hist[histptr])-1 DO
	  procptr^[i]:=Text.GetChar(hist[histptr],i);      
	END; (* FOR *)     
	llength:=Text.Length(hist[histptr]); 
	Terminal.PutText(hist[histptr]);
      ELSE
	histptr:=-1;
	WHILE llength>0 DO (* Delete written Command on Screen. *)     
	  DosIO.ScreenGetCursor(row, col);    
	  DEC(col);
	  DEC(llength);
	  procptr^[llength]:=Char.NUL;
	  IF col<0 THEN
	    DosIO.ScreenSetCursor(row-1,maxcols-1);  
	  ELSE
	    DosIO.ScreenSetCursor(row, col);             
	  END; (* IF *)      
	  SIO.PutChar(' ',Stdio.stdout); 
	  Wr.Flush(Stdio.stdout);
	  IF col<0 THEN
	    DosIO.ScreenSetCursor(row-1,maxcols-1);        
	  ELSE
	    DosIO.ScreenSetCursor(row, col);  
	  END; (* IF *)
	END; (* WHILE *)
      END; (* IF *)
    END; (* IF *)
    asccode:=DosIO.getxkey();
  END; (* WHILE *)
  i:=0;
  WHILE i<=maxcmdlength-1 AND procptr^[i]#Char.NUL DO
    (* Converting the ARRAY OF CHAR in TEXT. *)
    line:=line&Text.FromChar(procptr^[i]);
    INC(i);
  END; (* WHILE *)
  Terminal.PutText("\n");
  InsertCmd(line,hist);  (* Inserts last Command in history list. *)
END GetCmdLine;


CONST maxcmdlength=400; (* Maximum length of Commandline. *)         
      HistSize=25;

VAR
    params, file_params: REF ARRAY OF TEXT;
    line: TEXT;
    history:=ARRAY [0..HistSize] OF TEXT {"",..};
    maxrows, maxcols, offset, i:INTEGER;
    read_file_ptr:SF.Reader:=NIL;
    f_inp:BOOLEAN:=FALSE;
    nl:[1..2]:=2;
    warn_level:TEXT:="1";
BEGIN
    TRY       
	maxrows:=DosIO.ScreenRows();
	maxcols:=DosIO.ScreenCols();
	LOOP
	    REPEAT
		IF NOT f_inp THEN
		  Wr.PutText(Stdio.stdout, "m3> ");
		  Wr.Flush(Stdio.stdout);
		  GetCmdLine(line,history);
		  params := ParseCommand(line);
		  IF NUMBER(params^)>0 AND
		     (Text.Equal(params^[0],"<") AND NUMBER(params^)>1 OR
		      Text.GetChar(params^[0],0)='<' AND
		      Text.Length(params^[0])>1) THEN
		    (* Gets input from a file(s). *)
		    IF Text.Equal(params^[0],"<") THEN
		      offset:=1;
		    ELSE
		      params^[0]:=Text.Sub(params^[0],1,
				  Text.Length(params^[0])-1);
		      offset:=0;
		    END; (* IF *)
		    file_params:=params;
		    i:=0;
		    f_inp:=TRUE;
		    line:="";
		  ELSIF NUMBER(params^)>0 AND
		     (Text.Equal(params^[0],"<") AND NUMBER(params^)<2 OR
		      Text.GetChar(params^[0],0)='<' AND
		      Text.Length(params^[0])<2) THEN
		    Error("Inputfile(s) required!");
		    line:="";
		  END; (* IF *)
		ELSE
		  IF i+offset<=NUMBER(file_params^)-1 THEN
		    IF read_file_ptr=NIL THEN
		      Terminal.PutText("FETCHING INPUT FROM FILE: '"&
					file_params^[i+offset]&"'\n");
		      IF SF.FileExists(file_params^[i+offset]) THEN
			read_file_ptr:=SF.OpenRead(file_params^[i+offset]);
		      ELSE
			Terminal.PutText("**** File doesn't exist!\n");
			read_file_ptr:=NIL;
			INC(i);
		      END; (* IF *)
		      line:="";
		    ELSE
		      IF NOT SIO.End(read_file_ptr) THEN
			line:=MyFile.GetLine(read_file_ptr);
			Terminal.PutText("Processing: '"&line&"'\n");
			params:=ParseCommand(line);
		      ELSE
			SF.CloseRead(read_file_ptr);  
			read_file_ptr:=NIL;
			INC(i);
			line:="";
		      END; (* IF *)
		    END; (* IF *)
		  ELSE
		    line:="";
		    f_inp:=FALSE;
		  END; (* IF *)
		END; (* IF *)
	    UNTIL line # NIL AND NOT Text.Equal(line, "") AND
		  NUMBER(params^)>0;

	(* Commands *)
	(*----------*)
	    (*exit*)
	    IF Text.Equal(FileSys.Caps(params^[0]), "exit") THEN
		EXIT

	    (* make *)
	    ELSIF Text.Equal(FileSys.Caps(params^[0]), "make") THEN
	      
	      IF NUMBER(params^) = 2 THEN
		CompileModules(params^[1], FALSE, nl)
	      ELSIF NUMBER(params^)=3 THEN
		IF Text.Equal(params^[1],"-deb") THEN
		  CompileModules(params^[2], TRUE, nl);
		ELSE
		  Error("Wrong option for make (only -deb allowed)!");
		END; (* IF *)
	      ELSE
		Error("cd: too many parameter");
	      END;
	    
	    (* Compilerwarnings on. *)    
	    ELSIF Text.Equal(FileSys.Caps(params^[0]), "won") THEN
	      warn_level:="1";

	    (* Compilerwarnings off. *)
	    ELSIF Text.Equal(FileSys.Caps(params^[0]), "woff") THEN
	      warn_level:="3";

	    (* listing on/off *)
	    ELSIF Text.Equal(FileSys.Caps(params^[0]), "lon") THEN
	      (* All errors and warnigs are generated in the
		 compilerlisting. *)
	      nl:=2;
	    ELSIF Text.Equal(FileSys.Caps(params^[0]), "loff") THEN
	      nl:=1;

	    (* cd *)
	    ELSIF Text.Equal(FileSys.Caps(params^[0]), "cd") THEN
		TRY
		    CASE NUMBER(params^) OF
		      1=> System.ChangeDir(HOME);
		    | 2=> System.ChangeDir(FileSys.ChangeBackslash(params^[1]));
		    ELSE
			RAISE System.Error("cd: too many parameter");
		    END;
					Message(System.GetCurrentDir());
		EXCEPT
		  System.Error (text) => Error(text);
		END;

	    (* m3mapentry *)
	    ELSIF Text.Equal(FileSys.Caps(params^[0]), "m3mapentry") THEN
		TRY
		    FOR i:= 1 TO LAST(params^) DO
					    Message("new namemap-entry: "
								&NameMap.GetDos(params^[i], add:= TRUE));
		    END;
		EXCEPT
		  Rd.Failure (text) => Error(text);
		END;

	    (* m3delmapentry *)
	    ELSIF Text.Equal(FileSys.Caps(params^[0]), "m3delmapentry") THEN
		TRY
		    FOR i:= 1 TO LAST(params^) DO
						NameMap.Remove(NameMap.GetLong(params^[i]));
					    Message("removed namemap-entry: "&params^[i]);
		    END;
		EXCEPT
		  Wr.Failure (text) => Error(text);
		END;

	    (* pwd *)
	    ELSIF Text.Equal(FileSys.Caps(params^[0]), "pwd") THEN
				Message(System.GetCurrentDir());

	    (* ls *)
	    ELSIF Text.Equal(FileSys.Caps(params^[0]), "ls") THEN
		ListDir(SUBARRAY(params^, 1, NUMBER(params^) - 1))

	    (* help *)
	    ELSIF Text.Equal(FileSys.Caps(params^[0]), "help") THEN
		HelpMessage();

	    (* Some Command *)
	    ELSE
		line := FileSys.ChangeSlash(params^[0]);
		FOR i := 1 TO LAST(params^) DO
		  line := line&" "&FileSys.ChangeSlash(params^[i]);
		END;
		TRY
		    System.CallProg(line);
		EXCEPT
		  System.Error => Error("can not execute " & params^[0]);
		END;
	    END;
	END;                         (*LOOP*)
    EXCEPT
	Rd.EndOfFile=> Error("exit");
    END;
END m3shell.
