(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: BuiltinArgs.m3                                        *)
(* Last modified on Mon Jun 29 16:07:42 PDT 1992 by kalsow     *)
(*      modified on Thu Jul 27 17:26:41 1989 by muller         *)

MODULE BuiltinArgs;

IMPORT String, Formal, Int, Reel, LReel, Addr, Card;
IMPORT SubrangeType, Target, Type, Value;

PROCEDURE Initialize () =
  VAR x, y, i, n: String.T;
  BEGIN
    x := String.Add ("x");
    y := String.Add ("y");
    i := String.Add ("i");
    n := String.Add ("n");
    f1  := Add (x, 0, Int.T);
    f2  := Add (x, 0, Reel.T);
    f3  := Add (x, 0, LReel.T);
    f4  := Add (x, 0, Addr.T);
    f5  := Add (y, 1, Int.T);
    f6  := Add (y, 1, Reel.T);
    f7  := Add (y, 1, LReel.T);
    f8  := Add (y, 1, Addr.T);
    f9  := Add (i, 1, Card.T);
    f10 := Add (n, 2, Card.T);
    f11 := Add (i, 2, Card.T);
    f12 := Add (n, 3, Card.T);
    f13 := Add (n, 1, Int.T);
    f14 := Add (n, 1, SubrangeType.New (0, Target.INTSIZE-1, Int.T));
  END Initialize;

PROCEDURE Add (name: String.T; offset: INTEGER; type: Type.T): Value.T =
  BEGIN
    RETURN Formal.New (Formal.Info {
                           name   := name,
                           offset := offset,
                           mode   := Formal.Mode.mVALUE,
                           type   := type,
                           dfault := NIL,
                           unused := FALSE,
                           trace  := NIL});
  END Add;

BEGIN
END BuiltinArgs.
