(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: WordLT.m3                                             *)
(* Last Modified On Tue Jun 30 09:33:16 PDT 1992 By kalsow     *)
(*      Modified On Tue Apr 10 11:13:37 1990 By muller         *)

MODULE WordLT;

IMPORT Word, CallExpr, Expr, Type, Procedure, Emit, Temp;
IMPORT Bool, WordPlus, Value, Formal, BuiltinArgs, ProcType;

VAR Z: CallExpr.MethodList;
VAR formals: ARRAY [0..1] OF Value.T;

PROCEDURE Check (<*UNUSED*> proc: Expr.T; VAR args: Expr.List;  VAR cs: Expr.CheckState): Type.T =
  BEGIN
    EVAL Formal.CheckArgs (cs, args, formals);
    RETURN Bool.T;
  END Check;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  VAR t1, t2, t3: Temp.T;
  BEGIN
    t1 := Expr.Compile (args[0]);
    t2 := Expr.Compile (args[1]);
    t3 := Temp.AllocEmpty (Bool.T);
    Emit.OpTTT ("@ = (unsigned)@ < (unsigned)@;\n", t3, t1, t2);
    Temp.Free (t1);
    Temp.Free (t2);
    RETURN t3;
  END Compile;

PROCEDURE Fold (<*UNUSED*> proc: Expr.T; args: Expr.List): Expr.T =
  VAR w0, w1: Word.T;
  BEGIN
    IF WordPlus.GetArgs (args, w0, w1)
      THEN RETURN Bool.Map[Word.LT (w0, w1)];
      ELSE RETURN NIL;
    END;
  END Fold;

PROCEDURE Initialize () =
  BEGIN
    formals[0] := BuiltinArgs.f1;
    formals[1] := BuiltinArgs.f5;
    Z := CallExpr.NewMethodList (2, 2, TRUE, TRUE, Bool.T,
                                 NIL, Check, Compile, Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define ("LT", Z, FALSE, ProcType.New (formals, Bool.T));
  END Initialize;

BEGIN
END WordLT.
