(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: WordNot.m3                                            *)
(* Last Modified On Tue Jun 30 09:35:25 PDT 1992 By kalsow     *)
(*      Modified On Tue Apr 10 11:15:33 1990 By muller         *)

MODULE WordNot;

IMPORT Word, CallExpr, Expr, Type, Procedure, Emit, Temp;
IMPORT Int, IntegerExpr, Value, Formal, BuiltinArgs, ProcType;

VAR Z: CallExpr.MethodList;
VAR formals: ARRAY [0..0] OF Value.T;

PROCEDURE Check (<*UNUSED*> proc: Expr.T; VAR args: Expr.List;  VAR cs: Expr.CheckState): Type.T =
  BEGIN
    EVAL Formal.CheckArgs (cs, args, formals);
    RETURN Int.T;
  END Check;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  VAR t1, t2: Temp.T;
  BEGIN
    t1 := Expr.Compile (args[0]);
    t2 := Temp.AllocEmpty (Int.T);
    Emit.OpTT ("@ = ~ @;\n", t2, t1);
    Temp.Free (t1);
    RETURN t2;
  END Compile;

PROCEDURE Fold (<*UNUSED*> proc: Expr.T; args: Expr.List): Expr.T =
  VAR e: Expr.T;  w: Word.T;
  BEGIN
    e := Expr.ConstValue (args[0]);
    IF (e # NIL) AND IntegerExpr.Split (e, w)
      THEN RETURN IntegerExpr.New (Word.Not (w));
      ELSE RETURN NIL;
    END;
  END Fold;

PROCEDURE Initialize () =
  BEGIN
    formals[0] := BuiltinArgs.f1;
    Z := CallExpr.NewMethodList (1, 1, TRUE, TRUE, Int.T,
                                 NIL, Check, Compile, Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define ("Not", Z, FALSE, ProcType.New (formals, Int.T));
  END Initialize;

BEGIN
END WordNot.
