(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: QualifyExpr.i3                                        *)
(* Last Modified On Tue Jun  2 15:48:12 PDT 1992 By kalsow         *)
(*      Modified On Sat Aug 18 01:13:38 1990 By muller         *)

INTERFACE QualifyExpr;

IMPORT Expr, String, Value, Type, Temp;

PROCEDURE New (a: Expr.T;  id: String.T): Expr.T;

PROCEDURE Split (e: Expr.T; VAR v: Value.T): BOOLEAN;

PROCEDURE SplitQID (e: Expr.T; VAR module, item: String.T): BOOLEAN;

PROCEDURE MethodType (e: Expr.T): Type.T;

PROCEDURE CompileProc (e: Expr.T;  VAR obj: Temp.T): Temp.T;
(* compiles 'e' and returns the result.  If 'e' is 'object.method',
   sets 'obj' to the temporary holding the 'object', otherwise
   sets 'obj' to NIL. *)

END QualifyExpr.
