(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: SetExpr.i3                                            *)
(* Last Modified On Fri May 29 16:19:45 PDT 1992 By muller     *)
(*      Modified On Mon Mar  2 10:18:20 PST 1992 By kalsow     *)

INTERFACE SetExpr;

IMPORT Type, Expr, Temp, CompareExpr;

PROCEDURE New (type: Type.T;  args: Expr.List): Expr.T;

PROCEDURE Is (e: Expr.T): BOOLEAN;

PROCEDURE Compare       (a, b: Expr.T;  VAR s: INTEGER): BOOLEAN;
PROCEDURE Union         (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN;
PROCEDURE Intersection  (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN;
PROCEDURE Difference    (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN;
PROCEDURE SymDifference (a, b: Expr.T;  VAR c: Expr.T): BOOLEAN;
PROCEDURE Include       (set, elt: Expr.T;  VAR c: Expr.T): BOOLEAN;
PROCEDURE Exclude       (set, elt: Expr.T;  VAR c: Expr.T): BOOLEAN;
PROCEDURE Member        (set, elt: Expr.T;  VAR c: Expr.T): BOOLEAN;

PROCEDURE CompileAssign (range: Type.T; l, r: Temp.T);
PROCEDURE CompileUnion (t1, t2, t3: Temp.T; t: Type.T);
PROCEDURE CompileInter (t1, t2, t3: Temp.T; t: Type.T);
PROCEDURE CompileDiff  (t1, t2, t3: Temp.T; t: Type.T);
PROCEDURE CompileDiv   (t1, t2, t3: Temp.T; t: Type.T);
PROCEDURE CompileTCompare (t1,t2,t3: Temp.T; t: Type.T; op: CompareExpr.Op); 
PROCEDURE CompileLCompare (p1, p2: Temp.T;  label: INTEGER; t: Type.T);
PROCEDURE CompileMember (e1, e2: Expr.T; t3: Temp.T; t: Type.T);

END SetExpr.
