(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: External.i3                                           *)
(* Last Modified On Mon Mar  2 10:21:57 PST 1992 By kalsow     *)

INTERFACE External;

IMPORT String, Module, Value;

TYPE Set <: ADDRESS;

PROCEDURE NewSet (): Set;

PROCEDURE NoteExport (s: Set;  name: String.T);
PROCEDURE NoteImport (s: Set;  im: Module.T;  name: String.T);

PROCEDURE ParseImports (s: Set;  self: Module.T);
PROCEDURE LoadImports  (s: Set;  self: Module.T);
PROCEDURE GenLinkInfo  (s: Set);
PROCEDURE GenImports   (s: Set);
PROCEDURE InitGlobals  (s: Set);

PROCEDURE IsExportable (v: Value.T): BOOLEAN;
PROCEDURE Redirect (intf, impl: Value.T);

END External.
