(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Method.i3                                             *)
(* Last Modified On Thu Aug 22 00:45:22 1991 By kalsow         *)
(*      Modified On Wed Mar 20 00:26:12 1991 By muller         *)


INTERFACE Method;

IMPORT Type, String, Value, Expr;

PROCEDURE New (name      : String.T;
               offset    : INTEGER;
               parent    : Type.T;
               signature : Type.T;
               dfault    : Expr.T): Value.T;

PROCEDURE Split (method   : Value.T;
             VAR offset   : INTEGER;
             VAR override : BOOLEAN;
             VAR sig      : Type.T): BOOLEAN;

PROCEDURE SplitX (method   : Value.T;
              VAR offset   : INTEGER;
              VAR override : BOOLEAN;
              VAR sig      : Type.T);

PROCEDURE GetDefault (method: Value.T): Value.T;

PROCEDURE NoteOverride (new, old: Value.T);

PROCEDURE IsEqual (va, vb: Value.T;  x: Type.Assumption): BOOLEAN;

END Method.
