(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Procedure.i3                                          *)
(* Last Modified On Wed Apr 15 09:57:20 PDT 1992 By kalsow     *)
(*      Modified On Tue Oct  9 23:46:24 1990 By muller         *)

INTERFACE Procedure;

IMPORT M3, Value, Type, Token, CallExpr, Decl;

TYPE T <: Value.T;

PROCEDURE ParseDecl (READONLY fail       : Token.Set;
                              att        : Decl.Attributes;
                              headerOnly : BOOLEAN  := FALSE);

PROCEDURE Signature   (t: T): Type.T;
PROCEDURE HasBody     (t: T): BOOLEAN;
PROCEDURE IsNested    (t: T): BOOLEAN;
PROCEDURE RequiresClosure (t: T): BOOLEAN;

PROCEDURE EmitFrameName (t: T): BOOLEAN;

PROCEDURE Define (name      : TEXT;
                  methods   : CallExpr.MethodList;
                  reserved  : BOOLEAN;
                  signature : Type.T := NIL
                  );

PROCEDURE CheckBody (t: T;  VAR cs: Value.CheckState);
PROCEDURE GenBodies ();

PROCEDURE CanBeInlined (t: T): BOOLEAN;
PROCEDURE ExpandInline (t: T;  READONLY actuals: ARRAY OF M3.Temp): M3.Temp;

PROCEDURE IsEqual (a, b: Value.T): BOOLEAN;

PROCEDURE NoteExport (impl, intf: Value.T);

PROCEDURE Reset ();

END Procedure.
