(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: OS.i3                                                 *)
(* Last modified on Thu Feb 13 16:32:53 PST 1992 by kalsow     *)
(*      modified on Tue Nov 12 14:05:29 PST 1991 by muller     *)


(* This interface defines the OS-specific functions needed by
   the Modula-3 driver. *)

INTERFACE OS;

IMPORT Rd, Wr;

PROCEDURE NumParameters (): INTEGER;
PROCEDURE GetParameter (n: INTEGER): TEXT;


CONST NO_TIME = FIRST (INTEGER);

PROCEDURE CreateTime (file: TEXT): INTEGER;
PROCEDURE Now (): INTEGER;

PROCEDURE Remove (file: TEXT);
PROCEDURE Rename (old, new: TEXT);
PROCEDURE Clone (old, new: TEXT);

PROCEDURE NewExec (name: TEXT): Wr.T;

TYPE Dir <: REFANY;

PROCEDURE OpenDir  (name: TEXT): Dir;
PROCEDURE ReadDir  (d: Dir): TEXT;
PROCEDURE CloseDir (d: Dir);

TYPE RunResult = RECORD signal, status: INTEGER;  core_dumped: BOOLEAN END;
TYPE ArgList = REF ARRAY OF TEXT;

PROCEDURE Run (program: TEXT;  argv: ArgList): RunResult;
PROCEDURE Exit (n: INTEGER);
PROCEDURE OnShutDown (cleanup: PROCEDURE ());


(* stolen from UProcess... *)
TYPE
  Handle = OBJECT
             pid    : CARDINAL := 0;  (* the process ID (pid) *)
             stdin  : Wr.T := NIL;
             stdout : Rd.T := NIL;
             error  : TEXT := NIL;
           END;

PROCEDURE Fork (program: TEXT;  argv: ArgList): Handle;
PROCEDURE Stop (h: Handle;  wait: BOOLEAN := FALSE);

(*---------------------------------------------------- missing Unix hooks ---*)

<*EXTERNAL*>
PROCEDURE waitpid (pid: INTEGER; VAR status: INTEGER; opts: INTEGER): INTEGER;

END OS.
