(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Created by Jorge Stolfi on Sat Oct  7  2:51:33 PDT 1989     *)
(* Last modified on Tue Feb 11 21:39:38 PST 1992 by muller     *)
(*      modified on Thu Oct 25  8:58:42 PDT 1990 by stolfi     *)

MODULE YPQ;

IMPORT RGB;

PROCEDURE RGBFromYPQ (ypq: T): RGB.T =
  BEGIN
    IF ypq = Undefined THEN RETURN RGB.Undefined END;
    RETURN RGB.T{
      ypq[0] * Yr + ypq[1] * Pr + ypq[2] * Qr,
      ypq[0] * Yg + ypq[1] * Pg + ypq[2] * Qg,
      ypq[0] * Yb + ypq[1] * Pb + ypq[2] * Qb
    }
  END RGBFromYPQ;

PROCEDURE YPQFromRGB (rgb: RGB.T): T =
  BEGIN
    IF rgb = RGB.Undefined THEN RETURN Undefined END;
    RETURN T{
      rgb[0] * rY + rgb[1] * gY + rgb[2] * bY,
      rgb[0] * rP + rgb[1] * gP + rgb[2] * bP,
      rgb[0] * rQ + rgb[1] * gQ + rgb[2] * bQ
    }
  END YPQFromRGB;

BEGIN
END YPQ.
