(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)

(* Last Modified On Fri May 29 16:48:29 PDT 1992 by muller                   *)

MODULE PerfTool;

IMPORT Rd, Wr, Ctypes, UFileRdWr, Text, LowPerfTool, RTParams;

PROCEDURE Start (name: Text.T; VAR rd: Rd.T; VAR wr: Wr.T): BOOLEAN =
  VAR r, w: Ctypes.int;
BEGIN
  IF NOT LowPerfTool.Start (name, r, w) THEN 
    RETURN FALSE; END;

  (* create rd and wr *)
  TRY
    rd := UFileRdWr.CreateFileReader (r);
    wr := UFileRdWr.CreateFileWriter (w);
  EXCEPT
    | Rd.Failure, Wr.Failure => RETURN FALSE; END;
  RETURN TRUE;
END Start;

PROCEDURE StartAndWait (name: Text.T; VAR rd: Rd.T; VAR wr: Wr.T): BOOLEAN =
  VAR r, w: Ctypes.int;
BEGIN
  IF NOT LowPerfTool.StartAndWait (name, r, w) THEN
    RETURN FALSE; END;

  TRY
    rd := UFileRdWr.CreateFileReader (r);
    wr := UFileRdWr.CreateFileWriter (w);
  EXCEPT 
    | Rd.Failure, Wr.Failure => RETURN FALSE; END;
  RETURN TRUE;
END StartAndWait;

PROCEDURE ParamStart (param: Text.T; VAR rd: Rd.T; wr: Wr.T): BOOLEAN =
  VAR value := RTParams.Value (param);
  BEGIN
    IF value = NIL THEN
      RETURN FALSE;
    ELSIF Text.Length (value) = 0 THEN
      RETURN Start (param, rd, wr);
    ELSE 
      RETURN Start (value, rd, wr); END;
  END ParamStart;

PROCEDURE ParamStartAndWait (param: Text.T;
                             VAR rd: Rd.T; VAR wr: Wr.T): BOOLEAN =
  VAR value := RTParams.Value (param);
  BEGIN
    IF value = NIL THEN
      RETURN FALSE;
    ELSIF Text.Length (value) = 0 THEN
      RETURN StartAndWait (param, rd, wr);
    ELSE 
      RETURN StartAndWait (value, rd, wr); END;
  END ParamStartAndWait;

      

BEGIN
END PerfTool.
