(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Sat Aug  3 01:25:40 1991 by kalsow         *)
(*      modified on Tue Jun 25 10:53:55 1991 by muller         *)

MODULE NullRd;

IMPORT Rd, RdClass;

REVEAL T = Rd.T BRANDED OBJECT
           OVERRIDES
             seek := Seek;
             close := Close;
           END;

PROCEDURE New (): T = 
  BEGIN
    RETURN (NEW (T,
	            st := 0,
		    lo := 0,
		    cur := 0,
		    hi := 0,
	            buff := NIL,
		    closed := FALSE, 
		    seekable := FALSE,
	            intermittent := FALSE));
  END New;

PROCEDURE Seek (<*UNUSED*> rd: T; 
                <*UNUSED*> dontBlock: BOOLEAN): RdClass.SeekResult
   RAISES {} =
  BEGIN
    RETURN (RdClass.SeekResult.Eof);
  END Seek;


PROCEDURE Close (rd: T) RAISES {} =
  BEGIN
    rd.buff := NIL;
    rd.closed := TRUE;
  END Close;

BEGIN
END NullRd.


                
  
