/* Testing compiler's random number generator against Minimal Standard generator*/
/* in 22.8.1999 by Aleksi Kallio, no copyrights */

#include <fstream.h>
#include <time.h>
#include <stdlib.h>


// Following is from Numerical Recipes In C [Press et al.]
// I have edited it to make it more C++-style.

const long IA = 16807;
const long IM = 2147483647;
const double AM = (1.0/IM);
const long IQ = 127773;
const long IR = 2836;
const long MASK=123459876;

double ran0(long& idum) // long equals to long int, reference because ran0 alters idum
{
    long k;
    double ans;

    idum ^= MASK;      // ^= is bitwise operation XOR
    k = idum/IQ;
    idum = IA * (idum - k*IQ) - IR*k;
    if (idum < 0) idum += IM;
    ans = AM * idum;
    idum ^= MASK;
    return ans;
}   


const long int AMOUNT_NUMBERS = 230;
const long int AMOUNT_RANDS = 10000*AMOUNT_NUMBERS;

void main()
{
    cout << "RAND_MAX is " << RAND_MAX << endl;
    
    long randSeed = time(0);    // initialise compilers random number generator
    srand(randSeed);
    long a = 0;
    
    int numbersR[AMOUNT_NUMBERS]; // array for compilers generator
    int numbers0[AMOUNT_NUMBERS]; // array for ran0 generator

    for (a=0; a < AMOUNT_NUMBERS; a++) {
        numbersR[a] = 0;
        numbers0[a] = 0;
    }

    cout << "Please wait a sec, processing.." << endl;
    
    for (a=0; a < AMOUNT_RANDS; a++) {  // here we calculate and store random numbers
        numbersR[rand() % AMOUNT_NUMBERS] ++;
        numbers0[int(ran0(randSeed) * double(AMOUNT_NUMBERS))] ++;
    }

    ofstream chartR("r_values.txt"); // then output to file
    ofstream chart0("z_values.txt");

    for (a=0; a < AMOUNT_NUMBERS; a++) {
        chartR << numbersR[a] << " ";
        chart0 << numbers0[a] << " ";
    }

    chartR.close();
    chart0.close();
}
