// ex13-5.c -- Virtual base classes and virtual functions

// $Header: ex13-5.c,v 2.204 89/10/08 14:40:39 keith Stab $

#include <iostream.h>

class V {
public:
    virtual void vf();
};

void V::vf()    { cout << "V::vf()" << endl; }

class A: public virtual V {
public:
    virtual void vf();
};

void A::vf()    { cout << "A::vf()" << endl; }

class B: public virtual V {
public:
    void fb()   { vf(); }
};

class C: public A, public B {
};

class D: public A, public B {
public:
    virtual void vf();
};

void D::vf()    { cout << "D::vf()" << endl; }

main()
{
    B b;
    b.fb();     // B::fb() calls V::vf()
    C c;
    c.fb();     // B::fb() calls A::vf() -- on another path of the DAG
    D d;
    d.fb();     // B::fb() calls D::vf()
}
