/* Bitset.c -- implementation of set of small integers

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	September, 1985

Function:
	
A Bitset is a set of small integers.  It is implemented very efficiently
using a single word.  Each bit of the word indicates if the integer
associated with the bit position is in the set.  Bitsets are
particularly useful in conjunction with enum constants.

$Log:	Bitset.c,v $
 * Revision 2.204  89/10/07  23:18:54  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:20  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:53:17  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:21  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/20  22:15:43  keith
 * Add Object::desc() to VIRTUAL_BASE_CLASSES.
 * Add explicit base class names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:56:49  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:16:20  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  10:56:41  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:07:13  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:13:17  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:27:53  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:03:32  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Bitset.h"
#include "nihclIO.h"

#define	THIS	Bitset
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Bitset,1,"$Header: Bitset.c,v 2.204 89/10/07 23:18:54 keith Stab $",NULL,NULL);

unsigned Bitset::capacity() const	{ return sizeof(int)*8; }

void Bitset::deepenShallowCopy()	{}

unsigned Bitset::hash() const	{ return m; }
	
bool Bitset::isEmpty() const	{ return m==0; }
	
bool Bitset::isEqual(const Object& ob) const
{
	return ob.isSpecies(classDesc) && *this==castdown(ob);
}

const Class* Bitset::species() const { return &classDesc; }

void Bitset::printOn(ostream& s) const
{
	Bitset t = *this;
	for (register unsigned i =0; i<capacity() && !t.isEmpty(); i++) {
		if (t.includes(i)) {
			s << i;
			t -= i;
			if (!t.isEmpty()) s << ',';
		}
	}
}

unsigned Bitset::size() const
{
	register unsigned l=m;
	register unsigned n=0;
	while (l != 0) {
		l &= (l-1);	// removes rightmost 1 
		n++;
	}
	return n;
}

Bitset::Bitset(OIOin& strm)
	: BASE(strm)
{
	strm >> m;
}

void Bitset::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << m;
}

Bitset::Bitset(OIOifd& fd)
	: BASE(fd)
{
	fd >> m;
}

void Bitset::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << m;
}

int Bitset::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}
