#ifndef	PROCESS_H
#define	PROCESS_H

/*$Header: Process.h,v 2.204 89/10/07 23:21:02 keith Stab $*/

/* Process.h -- Declarations for lightweight processes

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Process.h,v $
 * Revision 2.204  89/10/07  23:21:02  keith
 * Pre-release
 * 
 * Revision 2.203.1.2  89/09/01  15:03:03  keith
 * Make deepenShallowCopy() protected.
 * 
 * Revision 2.203.1.1  89/08/30  22:19:40  keith
 * Implement deepenVBase().
 * 
 * Revision 2.203  89/08/12  23:43:09  keith
 * Make storer functions protected so storeVBaseOn() in
 * DEFINE_CLASS can access.
 * 
 * Revision 2.202.1.2  89/07/04  19:37:44  keith
 * Remove Scheduler::addProcess() from Process constructors --
 * castdown() of derived class non-functional in base class constructor.
 * Add Process::add() to call Scheduler::addProcess().
 * 
 * Revision 2.202.1.1  89/07/01  21:55:31  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/26  21:26:01  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.202  89/06/26  21:23:54  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.5  89/06/26  21:20:58  keith
 * Make copy constructor protected so DEFINE_CLASS in derived
 * classes can compile.
 * 
 * Revision 2.201.1.4  89/06/24  13:20:02  keith
 * Use temporary in topOfStack() to avoid warning message.
 * 
 * Revision 2.201.1.3  89/06/22  10:16:19  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:17:01  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:43:34  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:19:44  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  11:00:28  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:09:28  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:17:12  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:30:41  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:08:11  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Link.h"
#include "String.h"
#include "nihclconfig.h"

#ifdef HAVE_SELECT
#include "FDSet.h"
#endif

const int MAXPRIORITY = 7;	// maximum process priority

class Catch;
class ExceptionActionTbl;
class ExceptionEnv;
class HeapProc;
class Scheduler;
class Semaphore;
class StackProc;

class Process: public Link {
	DECLARE_MEMBERS(Process);
public:			// type definitions
	typedef char* stackTy;
	enum processState { SUSPENDED, RUNNING, TERMINATED };
public:			// static member functions
	static void copyStack(const stackTy* src, stackTy* dst, unsigned long count);
	static stackTy* topOfStack() {
		auto stackTy top;
		stackTy* temp = &top;	// to avoid warning message
		return temp;
	}
private:
	String process_name;
	processState process_state;	// SUSPENDED, RUNNING, or TERMINATED 
	unsigned char process_priority;
	ExceptionEnv* saved_exception_env_stack_top;
	ExceptionActionTbl* saved_exception_action;
	Catch* saved_catch_stack_top;
protected:
#ifdef HAVE_SELECT
	FDSet rdmask, wrmask, exmask;	// masks for select(2)
#endif
	JMP_BUF env;			// environment save structure for setjmp/longjmp
	stackTy* stack_bottom;		// pointer to stack bottom

	friend Scheduler;
	friend Semaphore;
protected:
	Process(const char* name, stackTy* bottom, int priority =0);
	Process(stackTy* bottom, int priority =0);	// MAIN Process constructor
	Process(const Process&);			// shouldNotImplement()
	unsigned& PC()		{ return ENV_PC(env); }
	unsigned& SP()		{ return ENV_SP(env); }
	unsigned& FP()		{ return ENV_FP(env); }
	void add();					// add this process to Scheduler runlist
	virtual	void deepenShallowCopy();		// shouldNotImplement()
	virtual void restore();
	virtual void save();
	virtual void storer(OIOofd&) const;		// shouldNotImplement()
	virtual void storer(OIOout&) const;		// shouldNotImplement()
	virtual void switchContext(Process*) = 0;
	virtual void switchFrom(HeapProc*) = 0;
	virtual	void switchFrom(StackProc*) = 0;
public:
	~Process();
	const char* name() const	{ return process_name; }
	processState state() const	{ return process_state; }

#ifdef HAVE_SELECT
	virtual void select(FDSet&, FDSet&, FDSet&);	// add to select list
#endif

	virtual unsigned capacity() const;		// returns stack size 
	virtual int compare(const Object&) const;	// compare process priorities 
	virtual void dumpOn(ostream& strm =cerr) const;
	virtual unsigned hash() const;
	virtual bool isEqual(const Object& ob) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual unsigned char priority() const;
	virtual unsigned char priority(unsigned char newPriority);
	virtual void resume();
	virtual	unsigned size() const = 0;
	virtual void suspend();
	virtual void terminate();
private:				// shouldNotImplement()
	virtual Object* copy() const;
};

#endif
