#ifndef	SEQCLTN_H
#define	SEQCLTN_H

/*$Header: SeqCltn.h,v 2.204 89/10/07 23:21:32 keith Stab $*/

/* SeqCltn.h -- declarations for abstract sequential collections

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	SeqCltn.h,v $
 * Revision 2.204  89/10/07  23:21:32  keith
 * Pre-release
 * 
 * Revision 2.203.1.1  89/09/09  20:14:01  keith
 * Implement species().
 * Change isEqual() to do assertArgClass() test on argument.
 * 
 * Revision 2.203  89/08/08  15:24:17  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:55:59  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:56:01  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:17:15  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/21  12:00:42  keith
 * Make all constructors non-inline.
 * 
 * Revision 2.201.1.2  89/06/01  23:17:24  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:44:04  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:20:20  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.4  89/05/12  11:01:38  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.3  89/05/05  09:59:44  keith
 * Overload reference-returning member functions (e.g.
 * operator[](int) and at(int) for const instances.
 * 
 * Revision 2.200.1.2  89/05/03  23:10:15  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:18:17  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:31:19  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:09:14  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Collection.h"

class SeqCltn: public Collection {
	DECLARE_MEMBERS(SeqCltn);
protected:
	SeqCltn();
	void indexRangeErr() const;
public:
	virtual	Object* add(Object&) = 0;
	virtual Object*& at(int) = 0;
	virtual const Object *const& at(int) const = 0;
	virtual void atAllPut(Object& ob) = 0;
	virtual int compare(const Object&) const;
	virtual Object* doNext(Iterator&) const;
	virtual Object* first() const;
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual int indexOf(const Object& ob) const;
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0) const = 0;
	virtual Object* last() const;
	virtual unsigned occurrencesOf(const Object&) const;
	virtual Object* remove(const Object&) = 0;
	virtual void removeAll() = 0;
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0) = 0;
	virtual unsigned size() const = 0;
	virtual const Class* species() const;
};

#endif
