/* Test class Heap

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Modification History:
	
$Log:	heap.c,v $
 * Revision 2.204  89/10/07  23:50:26  keith
 * Pre-release
 * 
 * Revision 2.203.1.1  89/09/10  12:04:30  keith
 * Clean up.
 * Remove test involving change of value of Integer in heap.
 * 
 * Revision 2.203  89/08/08  14:51:09  keith
 * Pre-release
 * 
 * Revision 2.201  89/05/12  13:22:03  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.1  89/05/11  22:24:41  keith
 * Update for R2.0.
 * 
 * Revision 2.200  89/04/24  17:33:54  keith
 * Base revision for R2.0.
 * 
 * Revision 2.121  89/02/26  22:20:33  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.1  88/05/30  09:48:57  keith
 * Update for new dumpOn()/printOn() format.
 * 
 * Revision 2.0  88/03/29  13:26:52  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  22:24:43  keith
 * Initial revision
 * 

*/
static char rcsid[] = "$Header: heap.c,v 2.204 89/10/07 23:50:26 keith Stab $";

#include "Heap.h"
#include "Integer.h"
#include "OrderedCltn.h"
#include "Set.h"
#include "Point.h"

const int test1[] = {100, 70, 76, 22, 101, 54, 60, 2, 5, 601};
const int test2[] = {57, 36, 45, 59, 20, 14, 32, 18, 5, 28,
	17, 30, 16, 65, 34, 27, 30, 31, 80, 8,
	37, 39,	38, 45, 50, 15, 12, 13, 10, 25, 15};

main()
{
 	cout << "Testing Heap\n";
	OrderedCltn oc(10);
	for (int i = 0; i < sizeof test1/sizeof(int); i++)
		oc.add(*new Integer(test1[i]));
	cout << oc << endl;

	cout << "Test asHeap function\n";
	cout << "OrderedCltn as Heap: \n" << oc.asHeap() << endl;
	Heap heap1 = oc.asHeap();

	Heap heap2(1);		// Check reSize function
	for (i = (sizeof test1/sizeof(int))-1; i >=0; i--)
		heap2.add(*new Integer(test1[i]));
	cout << "Test isEqual function\n";
	cout <<  (heap1.isEqual(heap2) ? "SUCCESS" : "FAILURE") << endl;
	heap2.add(*new Integer(60));
	cout <<  (heap1!=heap2 ? "SUCCESS" : "FAILURE") << endl;
	heap2.removeFirst();
	cout <<  (heap1==heap2 ? "FAILURE" : "SUCCESS") << endl;

	Point A(1,1);
	Point B(1,2);
	Point C(1,3);
	Point D(1,3);
	Heap b(16);
	b.add(A);
	b.add(B);
	b.add(C);
	b.add(D);
	Heap c=b;
	cout << "c = " << c << endl;
	cout << "b = " << b << endl;
	cout << "b.first(): " << *(b.first()) << endl;
	cout << "b.last(): " << *(b.last()) << endl;
	Point E(4,5);
	b.add(E);
	cout << "b = " << b << endl;
	cout << "remove min from b " << *b.removeFirst() << endl;
	cout << "remove max from b " << *b.removeLast() << endl;
	Point F(3,2);
	Point G(1,4);
	Point H(5,6);
	Point I(0,1);
	Point J(9,8);
	b.add(F);
	b.add(G);
	b.add(H);
	b.add(I);
	b.add(J);
	b.add(I);
	b.add(B);
	b.add(A);
	b.add(B);
	cout << "b= " << b << endl; 
	cout << "\noccurrencesOf((1,2)): " << b.occurrencesOf(B) << endl;
	cout << "b.sort(): " << b.sort() << endl;
	cout << "b.asSet(): " << (b.asSet()) << "\n\n";

	cout << "Testing remove(Object&)\n";
	Heap aheap(15);
	for (i = 0; i < sizeof test2/sizeof(int); i++)
		aheap.add(*new Integer(test2[i]));
	cout << aheap << '\n' << endl;
	aheap.remove(*new Integer(10));
	cout << aheap << '\n' << endl;
	aheap.remove(*new Integer(80));	
	cout << aheap << '\n' << endl;
	aheap.remove(*new Integer(18));
	cout << aheap << '\n' << endl;
}
