/* DoubleVect.c -- Data type-specific functions for class DoubleVec

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	June, 1986

Function:
	
Data type -specific functions for class DoubleVec.

Modification History:

$Log:	DoubleVect.c,v $
 * Revision 2.204  89/10/08  09:42:41  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/14  11:23:44  ted
 * Removed register decl's
 * 
 * Revision 2.202  89/06/28  23:33:34  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201  89/05/12  13:46:13  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200  89/05/03  23:35:44  keith
 * Utilize abstract classes.
 * 
 * Revision 2.122  89/05/03  23:33:00  keith
 * 
 * 
 * Revision 2.121  89/04/25  13:32:18  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.2  89/02/08  14:21:34  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.1  88/07/17  12:48:52  keith
 * Update for revised NIHCL Object I/O.
 * 
 * Revision 2.0  88/03/29  21:55:49  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  09:47:14  keith
 * Initial revision
 * 
	
*/

#include "DoubleVec.h"
#include "FloatVec.h"
#include "nihclconfig.h"
#include "nihclIO.h"
#include <libc.h>

#define	THIS	DoubleVec
#define	BASE	Vector

// Conversion from float to double.  Added by tk.
DoubleVec::DoubleVec(const FloatVec& fv) :
       BASE(fv.length())
{
  v = NULL;
  if(n){
    v = new double[n];
    double* dp = v;
    const float* fp = fv.pt();
    unsigned i = n;
    while(i--) *dp++ = double(*fp++);
  }
}

static int typeCmp(const void* a, const void* b)
{
	double t = *(double*)a-*(double*)b;
	if (t < 0) return -1;
	if (t > 0) return 1;
	return 0;
}

void THIS::sort()
{
	qsort(v,n,sizeof(double),typeCmp);
}

unsigned THIS::hash() const
{
	unsigned h = n;
	unsigned i = n*div_sizeof_int(sizeof(double));
	unsigned* vv = (unsigned*)v;
	while (i--) h ^= *vv++;
	return h;
}

void THIS::printOn(ostream& strm) const
{
	for (unsigned i=0; i<n; i++) {
		if (i>0 && (i%6 == 0)) strm << "\n\t";
		strm << form("%13.4g",v[i]);
	}
}

void THIS::scanFrom(istream& strm)
{
	extern const int NIHCL_NYET;
	setError(NIHCL_NYET,DEFAULT,className(),"scanFrom");
}
