/* Vector.c -- abstract base class for vectors

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	February, 1987

Function:
	
Modification History:

$Log:	Vector.c,v $
 * Revision 2.204  89/10/08  09:43:00  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/14  22:05:23  keith
 * Pre-release
 * 
 * Revision 2.202  89/06/28  23:33:56  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/28  22:40:47  keith
 * Add explicit base class names to constructor initializer lists.
 * Hack work-around for BUG_bC2728.
 * 
 * Revision 2.201.1.1  89/06/19  21:50:43  keith
 * Base revision for R2.0 Cycle 18.
 * 
 * Revision 2.201  89/05/12  13:46:39  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200  89/05/03  23:36:08  keith
 * Utilize abstract classes.
 * 
 * Revision 2.122  89/05/03  23:33:21  keith
 * 
 * 
 * Revision 2.121  89/04/25  13:33:28  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.2  89/02/08  14:22:42  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.1  88/07/17  12:49:05  keith
 * Update for revised NIHCL Object I/O.
 * 
 * Revision 2.0  88/03/29  21:56:35  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  09:47:19  keith
 * Initial revision
 * 

*/

#include "Vector.h"
#include "nihclIO.h"

#define	THIS	Vector
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_ABSTRACT_CLASS(Vector,1,"$Header: Vector.c,v 2.204 89/10/08 09:43:00 keith Stab $",NULL,NULL);

extern const int NIHCL_RDABSTCLASS;
extern const int NIHCL_VECTOREMPTY;
extern const int NIHCL_VECTORLENGTH;

unsigned Vector::capacity() const   { return n; }

unsigned Vector::size()	const	    { return n; }

void Vector::free() {}	// used by Slice classes to free TempVecs

void Vector::emptyErr(const char* fname) const
{
	setError(NIHCL_VECTOREMPTY,DEFAULT,className(),fname,(int)this);
}

void lengthErr(const Vector& U, const Vector& V)
{
	NIHCL::setError(NIHCL_VECTORLENGTH,DEFAULT,(int)&U,U.className(),U.length(),(int)&V,V.className(),V.length());
}

void Vector::deepenShallowCopy()
// Called by deepCopy() to convert a shallow copy to a deep copy.
{
}

#ifndef BUG_bC2728
// call of pure virtual function OIOin::operator >>() in constructor Vector::Vector()
static unsigned hack(OIOin& strm)	{ unsigned n; strm >> n; return n; }
#endif

Vector::Vector(OIOin& strm)
// Construct an object from istream "strm" at address "where".
	: BASE(strm)
{
#ifndef BUG_bC2728
	n = hack(strm);
#else
// call of pure virtual function OIOin::operator >>() in constructor Vector::Vector()
	strm >> n;
#endif
}

void Vector::storer(OIOout& strm) const
// Store the member variables of this object on ostream "strm".
{
	BASE::storer(strm);
	strm << n;
}

Vector::Vector(OIOifd& fd)
// Construct an object from file descriptor "fd" at address "where".
	: BASE(fd)
{
	fd >> n;
}

void Vector::storer(OIOofd& fd) const
// Store an object on file descriptor "fd".
{
	BASE::storer(fd);
	fd << n;
}

int Vector::compare(const Object&) const
{
	shouldNotImplement("compare");
	return 0;
}
