/* $Id: genlido.c,v 1.3 1992/07/29 23:46:16 kadhim Exp $ */
/* Copyright, 1991, AG-Kastens, University Of Paderborn */

#include "obstack.h"
#include <stdio.h>
#include "envmod.h"
#include "csm.h"
#include "ptg_gen.h"
#include "genlido.h"
#include "support.h"
#include "gen_ins.h"
#include "err.h"

#ifndef FALSE
#define FALSE ((Boolean)0)
#endif
#ifndef TRUE
#define TRUE  ((Boolean)1)
#endif

void
FSymbol(fs, s)
  FILE *fs;
  char *s;
{
	fprintf(fs,"%s",s);
	return;
}

void
FString(fs, s)
  FILE *fs;
  char *s;
{
	fprintf(fs,"'");
	fprintf(fs,"%s",s);
	fprintf(fs,"'");
	return;
}

/* counter for rulenamegeneration */
static int cntr = 1;

/* maxlen of numberstring to be generated */
#define maxlen 8

/* Generates the rulename of a string and a number of length maxlen */
PTGNode GenProdName(env)
Environment env;
{
  int temp, idn;
  char *p;

  if ((p = (char *) malloc(maxlen+1)) == (char *) 0)
    {message(FATAL,"GenProdName(): Ran out of storage!",0,&curpos);}

  do {
    sprintf(p, "rule_%03d", cntr++);
    mkidn(p, maxlen, &temp, &idn);
  } while (KeyInEnv(env, idn) != NoKey);

  return(PTGSymbol(string[idn]));
}

int
isQChain(count, lhsid, rhsid)
int count, lhsid, rhsid;
{
  if ((count == 1) && (lhsid == rhsid))
    return TRUE;
  else
    return FALSE;
}

/* Generates a rule in the output if the rule was not present in the LIDO */
/* input */
PTGNode GenProdList(env,lhs,rhsl,count,lhsid,rhsid)
Environment env;
PTGNode lhs;
PTGNode rhsl; /* Could be list of PTGNodes in future version (alternatives) */
int count, lhsid, rhsid;
{
  char *str;
  int temp, idn, rulenum;
  DefTableKey key;

  obstack_1grow(&StrStack, '\0');
  str = (char *) obstack_finish(&StrStack);
  if (isQChain(count, lhsid, rhsid)) {
    obstack_free(&StrStack, str);
    return PTGNULL;
  } else {
    mkidn(str, strlen(str), &temp, &idn);
    key = KeyInEnv(env, idn);
    if (key != NoKey) {
      return PTGNULL;
    } else
      return(PTGRule(GenProdName(env),
                     lhs,
                     rhsl));
  }
}


PTGNode concatptgnodelist(p1,p2)
PTGNode p1,p2;
{
       if(p1==PTGNULL) return p2;
       if(p2==PTGNULL) return p1;
       return PTGSeq(p1,p2);
}

      
      
PTGNode GetSymbol(sid,symbol,kind)
int sid;
PTGNode symbol;
tag_type kind;
{
               switch (TAB[sid].tag)
               {   case TERM : if(kind==NON || TAB[sid].isprt) return PTGNULL;
				  else {TAB[sid].isprt=TRUE;
				       return PTGTerm(symbol);}
                               break;
                   case NON  : if(kind==TERM || TAB[sid].isprt) return PTGNULL;
				  else {TAB[sid].isprt=TRUE;
				       return PTGNonterm(symbol);}
                               break;
                   default   : return PTGNULL;
			       break;

               }
   return PTGNULL;
}

void OnlyStrictBNF(i)
int i; /* forget it */
{
      message(ERROR,"Only strict BNF allowed!",0,&curpos);
}


void NoMetaSymbols(i)
int i;  /* forget it */
{
     message(ERROR,"No meta symbols allowed!",0,&curpos);
}







