/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Reader;

public class BufferedReader
extends Reader {
    private Reader in;
    private char[] cb;
    private int nChars;
    private int nextChar;
    private static final int INVALIDATED = -2;
    private static final int UNMARKED = -1;
    private int markedChar = -1;
    private int readAheadLimit;
    private static int defaultCharBufferSize = 8192;
    private static int defaultExpectedLineLength = 80;

    public BufferedReader(Reader reader, int n) {
        super(reader);
        if (n <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.in = reader;
        this.cb = new char[n];
        this.nChars = 0;
        this.nextChar = 0;
    }

    public BufferedReader(Reader reader) {
        this(reader, defaultCharBufferSize);
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    private void fill() throws IOException {
        int n;
        int n2;
        if (this.markedChar <= -1) {
            n2 = 0;
        } else {
            n = this.nextChar - this.markedChar;
            if (n >= this.readAheadLimit) {
                this.markedChar = -2;
                this.readAheadLimit = 0;
                n2 = 0;
            } else if (this.readAheadLimit <= this.cb.length) {
                System.arraycopy(this.cb, this.markedChar, this.cb, 0, n);
                this.markedChar = 0;
                n2 = n;
            } else {
                char[] cArray = new char[this.readAheadLimit];
                System.arraycopy(this.cb, this.markedChar, cArray, 0, n);
                this.cb = cArray;
                this.markedChar = 0;
                n2 = n;
            }
        }
        while ((n = this.in.read(this.cb, n2, this.cb.length - n2)) == 0) {
        }
        if (n > 0) {
            this.nChars = n2 + n;
            this.nextChar = n2;
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException("Stream closed");
            }
            if (this.nextChar >= this.nChars) {
                this.fill();
                if (this.nextChar >= this.nChars) {
                    int n = -1;
                    Object var3_4 = null;
                    return n;
                }
            }
            char c = this.cb[this.nextChar++];
            Object var3_5 = null;
            return c;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException("Stream closed");
            }
            if (this.nextChar >= this.nChars) {
                if (n2 >= this.cb.length && this.markedChar <= -1) {
                    return this.in.read(cArray, n, n2);
                }
                this.fill();
            }
            if (this.nextChar >= this.nChars) {
                return -1;
            }
            int n3 = this.nChars - this.nextChar;
            n3 = n2 <= n3 ? n2 : n3;
            System.arraycopy(this.cb, this.nextChar, cArray, n, n3);
            this.nextChar += n3;
            return n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer(defaultExpectedLineLength);
        Object object = this.lock;
        synchronized (object) {
            char c;
            boolean bl;
            if (this.in == null) {
                throw new IOException("Stream closed");
            }
            do {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) {
                    if (stringBuffer.length() <= 0) return null;
                    return new String(stringBuffer);
                }
                bl = false;
                c = '\u0000';
                int n = this.nextChar;
                while (n < this.nChars) {
                    c = this.cb[n];
                    if (c == '\n' || c == '\r') {
                        bl = true;
                        break;
                    }
                    ++n;
                }
                stringBuffer.append(this.cb, this.nextChar, n - this.nextChar);
                this.nextChar = n;
            } while (!bl);
            ++this.nextChar;
            if (c != '\r') return new String(stringBuffer);
            if (this.nextChar >= this.nChars) {
                this.fill();
            }
            if (this.nextChar >= this.nChars) return new String(stringBuffer);
            if (this.cb[this.nextChar] != '\n') return new String(stringBuffer);
            ++this.nextChar;
            return new String(stringBuffer);
        }
    }

    public long skip(long l) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException("Stream closed");
            }
            long l2 = l;
            while (l2 > 0L) {
                if (this.nextChar >= this.nChars) {
                    this.fill();
                }
                if (this.nextChar >= this.nChars) break;
                long l3 = this.nChars - this.nextChar;
                if (l2 <= l3) {
                    this.nextChar = (int)((long)this.nextChar + l2);
                    l2 = 0L;
                    break;
                }
                l2 -= l3;
                this.nextChar = this.nChars;
            }
            long l4 = l - l2;
            Object var6_6 = null;
            return l4;
        }
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException("Stream closed");
            }
            boolean bl = this.nextChar < this.nChars || this.in.ready();
            Object var3_3 = null;
            return bl;
        }
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int n) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException("Stream closed");
            }
            this.readAheadLimit = n;
            this.markedChar = this.nextChar;
            return;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                throw new IOException("Stream closed");
            }
            if (this.markedChar < 0) {
                throw new IOException(this.markedChar == -2 ? "Mark invalid" : "Stream not marked");
            }
            this.nextChar = this.markedChar;
            return;
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                Object var2_2 = null;
                return;
            }
            this.in.close();
            this.in = null;
            this.cb = null;
            return;
        }
    }
}

