/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class PrintStream
extends FilterOutputStream {
    private boolean autoFlush = false;
    private boolean trouble = false;
    private BufferedWriter textOut;
    private OutputStreamWriter charOut;
    private boolean closing = false;

    public PrintStream(OutputStream outputStream) {
        this(outputStream, false);
    }

    public PrintStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        this.autoFlush = bl;
        this.charOut = new OutputStreamWriter(this);
        this.textOut = new BufferedWriter(this.charOut);
    }

    private void ensureOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    public void flush() {
        PrintStream printStream = this;
        synchronized (printStream) {
            try {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.out.flush();
            }
            catch (IOException iOException) {
                this.trouble = true;
            }
            return;
        }
    }

    public void close() {
        PrintStream printStream = this;
        synchronized (printStream) {
            if (!this.closing) {
                this.closing = true;
                try {
                    this.textOut.close();
                    this.out.close();
                }
                catch (IOException iOException) {
                    this.trouble = true;
                }
                this.textOut = null;
                this.charOut = null;
                this.out = null;
            }
            return;
        }
    }

    public boolean checkError() {
        if (this.out != null) {
            this.flush();
        }
        return this.trouble;
    }

    protected void setError() {
        this.trouble = true;
    }

    public void write(int n) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.out.write(n);
                if (n == 10 && this.autoFlush) {
                    this.out.flush();
                }
                return;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException iOException) {
            this.trouble = true;
            return;
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.out.write(byArray, n, n2);
                if (this.autoFlush) {
                    this.out.flush();
                }
                return;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException iOException) {
            this.trouble = true;
            return;
        }
    }

    private void write(char[] cArray) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.textOut.write(cArray);
                this.textOut.flushBuffer();
                this.charOut.flushBuffer();
                if (this.autoFlush) {
                    int n = 0;
                    while (n < cArray.length) {
                        if (cArray[n] == '\n') {
                            this.out.flush();
                        }
                        ++n;
                    }
                }
                return;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException iOException) {
            this.trouble = true;
            return;
        }
    }

    private void write(String string) {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.textOut.write(string);
                this.textOut.flushBuffer();
                this.charOut.flushBuffer();
                if (this.autoFlush && string.indexOf(10, 0) >= 0) {
                    this.out.flush();
                }
                return;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException iOException) {
            this.trouble = true;
            return;
        }
    }

    private void newLine() {
        try {
            PrintStream printStream = this;
            synchronized (printStream) {
                if (this.out == null) {
                    throw new IOException("Stream closed");
                }
                this.textOut.newLine();
                this.textOut.flushBuffer();
                this.charOut.flushBuffer();
                if (this.autoFlush) {
                    this.out.flush();
                }
                return;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException iOException) {
            this.trouble = true;
            return;
        }
    }

    public void print(boolean bl) {
        this.write(bl ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int n) {
        this.write(Integer.toString(n, 10));
    }

    public void print(long l) {
        this.write(Long.toString(l, 10));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] cArray) {
        this.write(cArray);
    }

    public void print(String string) {
        if (string == null) {
            string = "null";
        }
        this.write(string);
    }

    public void print(Object object) {
        this.write(object == null ? "null" : object.toString());
    }

    public void println() {
        this.newLine();
    }

    public void println(boolean bl) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(bl);
            this.newLine();
            return;
        }
    }

    public void println(char c) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(c);
            this.newLine();
            return;
        }
    }

    public void println(int n) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(n);
            this.newLine();
            return;
        }
    }

    public void println(long l) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(l);
            this.newLine();
            return;
        }
    }

    public void println(float f) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(f);
            this.newLine();
            return;
        }
    }

    public void println(double d) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(d);
            this.newLine();
            return;
        }
    }

    public void println(char[] cArray) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(cArray);
            this.newLine();
            return;
        }
    }

    public void println(String string) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(string);
            this.newLine();
            return;
        }
    }

    public void println(Object object) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(object);
            this.newLine();
            return;
        }
    }
}

