/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Float
extends Number {
    public static final float POSITIVE_INFINITY = 1.0f / 0.0f;
    public static final float NEGATIVE_INFINITY = -1.0f / 0.0f;
    public static final float NaN = 0.0f / 0.0f;
    public static final float MAX_VALUE = 3.4028235E38f;
    public static final float MIN_VALUE = 1.4E-45f;
    public static final Class TYPE = Class.getPrimitiveClass("float");
    private float value;
    private static final long serialVersionUID = -2671257302660747028L;

    public static String toString(float f) {
        return new FloatingDecimal(f).toJavaFormatString();
    }

    public static Float valueOf(String string) throws NumberFormatException {
        return new Float(Double.valueOf0(string));
    }

    public static boolean isNaN(float f) {
        return f != f;
    }

    public static boolean isInfinite(float f) {
        return f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY;
    }

    public Float(float f) {
        this.value = f;
    }

    public Float(double d) {
        this.value = (float)d;
    }

    public Float(String string) throws NumberFormatException {
        Float f = new Float(Double.valueOf0(string));
        this(f.value);
    }

    public boolean isNaN() {
        float f = this.value;
        return f != f;
    }

    public boolean isInfinite() {
        float f = this.value;
        return f == Float.POSITIVE_INFINITY || f == Float.NEGATIVE_INFINITY;
    }

    public String toString() {
        float f = this.value;
        return new FloatingDecimal(f).toJavaFormatString();
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof Float && Float.floatToIntBits(((Float)object).value) == Float.floatToIntBits(this.value);
    }

    public static native int floatToIntBits(float var0);

    public static native float intBitsToFloat(int var0);
}

