/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Hashtable;
import sun.misc.BASE64Decoder;
import sun.net.www.MessageHeader;
import sun.tools.jar.JarException;
import sun.tools.jar.Manifest;

class JarEntryVerifier {
    private static final boolean debug = false;
    private String[] supportedDigestHeader = new String[]{"MD5-Digest", "SHA-Digest"};
    private String[] supportedDigestAlg = new String[]{"MD5", "SHA"};
    private MessageDigest[] supportedDigest = new MessageDigest[]{null, null};
    private MessageDigest[] digest = new MessageDigest[]{null, null};
    private byte[][] manifestHash = new byte[][]{null, null};
    private BASE64Decoder decoder;
    private String name;

    JarEntryVerifier() throws JarException {
        try {
            int n = 0;
            while (n < this.supportedDigest.length) {
                this.supportedDigest[n] = MessageDigest.getInstance(this.supportedDigestAlg[n]);
                ++n;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException("unable to create MessageDigest objects");
        }
        this.decoder = new BASE64Decoder();
    }

    void setEntry(Manifest manifest, String string) throws IOException {
        this.digest[0] = null;
        this.digest[1] = null;
        if (manifest == null || string == null) {
            return;
        }
        MessageHeader messageHeader = manifest.getEntry(string);
        if (messageHeader == null && (messageHeader = manifest.getEntry("./" + string)) == null) {
            return;
        }
        this.name = string;
        int n = 0;
        while (n < this.supportedDigest.length) {
            String string2 = messageHeader.findValue(this.supportedDigestHeader[n]);
            if (string2 != null) {
                this.digest[n] = this.supportedDigest[n];
                this.digest[n].reset();
                this.manifestHash[n] = this.decoder.decodeBuffer(string2);
            } else {
                this.digest[n] = null;
                this.manifestHash[n] = null;
            }
            ++n;
        }
    }

    void update(byte by) {
        int n = 0;
        while (n < this.digest.length) {
            if (this.digest[n] != null) {
                this.digest[n].update(by);
            }
            ++n;
        }
    }

    void update(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < this.digest.length) {
            if (this.digest[n3] != null) {
                this.digest[n3].update(byArray, n, n2);
            }
            ++n3;
        }
    }

    void verify(Hashtable hashtable, Hashtable hashtable2) throws JarException {
        Object object;
        boolean bl = false;
        int n = 0;
        while (n < this.digest.length) {
            if (this.digest[n] != null) {
                object = this.digest[n].digest();
                if (!MessageDigest.isEqual((byte[])object, this.manifestHash[n])) {
                    throw new SecurityException(String.valueOf(this.supportedDigestAlg[n]) + " digest error for " + this.name);
                }
                bl = true;
            }
            ++n;
        }
        if (bl && (object = hashtable2.remove(this.name)) != null) {
            hashtable.put(this.name, object);
        }
    }
}

