let stdin = obj__magic 0
and stdout = obj__magic 1
and stderr = obj__magic 2
;;

let handle_unix_error f arg =
  try
    f arg
  with Unix_error(err, fun_name, arg) ->
    prerr_string sys__command_line.(0);
    prerr_string ": \"";
    prerr_string fun_name;
    prerr_string "\" failed";
    if string_length arg > 0 then begin
      prerr_string " on \"";
      prerr_string arg;
      prerr_string "\""
    end;
    prerr_string ": ";
    prerr_endline (error_message err);
    io__exit 2
;;

let default_handler () = ();;

let handler_table = [|
  default_handler; default_handler; default_handler; default_handler;
  default_handler; default_handler; default_handler; default_handler;
  default_handler; default_handler; default_handler; default_handler;
  default_handler; default_handler; default_handler; default_handler;
  default_handler; default_handler; default_handler; default_handler;
  default_handler; default_handler; default_handler; default_handler;
  default_handler; default_handler; default_handler; default_handler;
  default_handler; default_handler; default_handler; default_handler
|];;

let signal_handler n =
  if n < 0 or n >= 32 then () else handler_table.(n)()
;;  

let signal sig = function
    Signal_default ->
      let n = iunix__set_signal sig 0 in handler_table.(n) <- default_handler
  | Signal_ignore ->
      let n = iunix__set_signal sig 1 in handler_table.(n) <- default_handler
  | Signal_handle f ->
      iunix__install_signal_handler signal_handler;
      let n = iunix__set_signal sig 2 in handler_table.(n) <- f
;;

 
