/* Operations on strings */

#include "alloc.h"
#include "debugger.h"
#include "mlvalues.h"

mlsize_t string_length(s)
     value s;
{
  mlsize_t temp;
  temp = Bosize_val(s) - 1;
  Assert (Byte (s, temp - Byte (s, temp)) == 0);
  return temp - Byte (s, temp);
}

value create_string(len)        /* ML */
     value len;
{
  return alloc_string(Long_val(len));
}

value compare_strings(s1, s2)   /* ML */
     value s1, s2;
{
  mlsize_t len1, len2;
  register mlsize_t len;
  register unsigned char * p1, * p2;

  len1 = string_length(s1);
  len2 = string_length(s2);
  for (len = (len1 <= len2 ? len1 : len2),
         p1 = (unsigned char *) String_val(s1),
         p2 = (unsigned char *) String_val(s2);
       len > 0;
       len--, p1++, p2++)
    if (*p1 != *p2)
      return (*p1 < *p2 ? Val_long(-1) : Val_long(1));
  if (len1 == len2)
    return Val_long(0);
  else if (len1 < len2)
    return Val_long(-2);
  else
    return Val_long(2);
}

value blit_string(s1, offset1, s2, offset2, len) /* ML */
     value s1, offset1, s2, offset2, len;
{
  bcopy(&Byte(s1, Long_val(offset1)),
        &Byte(s2, Long_val(offset2)),
        Int_val(len));
  return Atom(0);
}

value fill_string(s, offset, len, init) /* ML */
     value s, offset, len, init;
{
  register char * p;
  register mlsize_t n;
  register char c;

  c = Long_val(init);
  for(p = &Byte(s, Long_val(offset)), n = Long_val(len);
      n > 0; n--, p++)
    *p = c;
  return Atom(0);
}

value get_vect16_item(v, n)         /* ML */
     value v, n;
{
  return Val_long(((unsigned char *) v)[n-1] + ((((schar *) v)[n]) << 8));
}
