-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "assoc_sym.t"
#include "attrcodefuncs.t"
#include "progtype.t"

export attrcode;

-- attrcode grammar production
--	Given a production, return the code to implement the reduce
--	function for this production.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/attrcode.m,v 1.1 88/04/19 17:04:48 pelle Exp $"
and
    attrcode
        (grammar as $,$,$,accept,$,fun,lookup,iattr,sattr,$,$)
        (lsymb,l,attr,$,num) =
        Funb(
	    App
	        (Aexp (fun ('r'.itos num)).
		(if null l then [Aexp (fun "statef1")] else []) @
		[
	        reduce (symbpat grammar) (Aexp "S") (reverse argstr);
	        Aexp "I"
	        ]),
	    if final
	        then
		    App [Aexp "Yes"; attrdef]
	        else
	    	    App
		        [
		        Aexp (fun "statef1");
		        App
		    	    (Aexp (fun "C" @ lookup lsymb) .
			    if null symbsattr
				then []
				else
    	    	    	    	    if null symbiattr
    	    	    	    	    	then [attrdef]
    	    	    	    	    	else
				    	    [
				    	    Lambda
			        	    	(attrpat grammar symbiattr "0")
			        	    	attrdef
			    	    	    ]);
		        Aexp "S";
		        Aexp "I"
		        ]
	    )
        where
    	    symbiattr = assoc_sym lsymb iattr
        and
	    final = lsymb = accept
        and rec
	    attrdef =
	        (if ~ null attr
	    	    then
	    	        Let
		    	    (Rec
		    	        (And
			    	    (map (attrbind grammar) attr @
				    reduce (symbcode grammar) [] argstr)))
		    	    retval
		    else
		        retval
	        where
		    retval = attrpat grammar symbsattr "0")
	and
	    symbsattr = assoc_sym lsymb sattr
        and
	    argstr = combine (l,map itos (count 1 (length l)))

end
