-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "assoc_sym.t"
#include "attrtype.t"
#include "progtype.t"

export attrbind, attrpat, symbcode, symbpat;

-- attrbind def		 : Return an attribute definition of type
--			 : progtype, corresponding to the argument.
--	def		 : The attribute definition.  Pair of lists of
--			 : Attributetype.

-- attrpat attrl n  	 : Return the an expression matching a series of
--  	    	    	 : attributes.
--  	attrl	    	 : A list of attribute names.
--  	n   	    	 : The number of the symbol in the production.

-- symbcode grammar (symbol,number) rest
--	Return the list of attribute definitions in "rest" augmented
--	with the definitions of synthesized attributes of "symbol" IFF
--	there are any such attributes.  "number" is the number of the
--	symbol in the production.

-- symbpat s no	    	 : Return a pattern for matching a symbol value in a
--  	    	    	 : stack.
--  	s   	    	 : The symbol matched.
--  	no  	    	 : The number of the symbol in the production.


    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/attrcodefuncs.m,v 1.1 88/04/19 17:04:49 pelle Exp $"
and rec
    symbcode (grammar as $,$,$,$,$,fun,$,iattr,sattr,$,$) (s,n) rest =
    	let
	    sattrlist = assoc_sym s sattr
	and
	    iattrlist = assoc_sym s iattr
	in
	    if null sattrlist
		then
		    rest
		else
		    Funb
			(attrpat grammar sattrlist n,
	    		App
			    (Aexp (fun "F" @ n) .
			    if null iattrlist
				then []
				else [attrpat grammar (assoc_sym s iattr) n]))
		    . rest
and
    symbpat ($,term,nont,$,$,fun,lookup,$,sattr,$,$) (sym,num) down =
	let
	    attri str = 
	    	if null (assoc_sym sym sattr)
		    then Aexp (fun "C" @ str)
	    	    else App [Aexp (fun "C" @ str); Aexp (fun "F" @ num)]
	in
    	    App
	    	[
	    	Aexp (fun "Stack");
		if mem sym nont then attri (lookup sym) else Aexp "$";
		if mem sym term then attri (lookup sym) else Aexp "$";
		Aexp (fun "statef" @ num);
		down
		]
and
    attrpat ($,$,$,$,$,fun,$,$,$,$,$) attrl n =
    	Tuple (map (\a. Aexp (fun "A" @ n @ a)) attrl)
and
    attrbind ($,$,$,$,$,fun,$,$,$,$,$) (pat,exp) =
    	Funb (attrtxt pat, attrtxt exp) where
    	    attrtxt l = Aexp ("(" @ concmap prtxt l @ ")") where
	    	prtxt (Attribute num name) = fun "A" @ itos num @ name
	    ||  prtxt (Text t) = t

end
