-- Copyright (C) 1987, 1988 G|ran Uddeborg
--
-- This file is part of FPG.
--
-- FPG is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY.  No author or distributor accepts responsibility to anyone for
-- the consequences of using it or for whether it serves any particular
-- purpose or works at all, unless he says so in writing.  Refer to the FPG
-- General Public License for full details.
--
-- Everyone is granted permission to copy, modify and redistribute FPG, but
-- only under the conditions described in the FPG General Public License.
-- A copy of this license is supposed to have been given to you along with
-- FPG so you can know your rights and responsibilities.  It should be in a
-- file named COPYING.  Among other things, the copyright notice and this
-- notice must be preserved on all copies.

module

#include "assoc_sym.t"
#include "isittype.t"

export compatible, find;

-- compatible nucleus1 nucleus2
--	Examine if two nucleuses are compatble, in the sense described
--	in D. Pagers article "A Practical General Method for
--	Constructing LR(k) Parsers" (Acta Informatica 7:249-268)

-- find sym isterminal nucleus states
--	Examine states to see if there is a state with a nucleus which
--	is equal to or greater than the given nucleus.  This nucleus
--	is for a state after a shift of symbol sym, whose kind is
--	given by isterminal.

    rcsid = " $Header: /usr/src/local/lml/contrib/fpg/RCS/itemsetfuncs.m,v 1.1 88/04/19 17:05:05 pelle Exp $"
and
    compatible (core,context) (core',context') =
	core = core' & (compat context context'
        where rec
	    compat [] [] = true
        ||  compat (hd.tl) (hd'.tl') =
	        checkone tl tl' hd hd' & compat tl tl'
	    	where rec
	    	    checkone [] [] $ $ = true
	    	||  checkone (ct2.tl) (ct2'.tl') ct1 ct1' =
		    	(NSisempty (NSintsect ct1 ct2') &
			    NSisempty (NSintsect ct1' ct2)  |
		    	~ NSisempty (NSintsect ct1 ct2) |
		    	~ NSisempty (NSintsect ct1' ct2')) &
		    	checkone tl tl' ct1 ct1')
and
    local
	lookup (newcore,newcontext) states =
	    case filter issub states in
		[] : Isn't
	    ||  ($,n,$).$ : Is n
	    end
	    where
		issub ((core,context),$,$) =
		    core = newcore & 
		    And (map NSisempty (map2 NSsub newcontext context))
    in
	find sym true ($,$,termstates) nucleus =
	    lookup nucleus (assoc_sym sym termstates)
    ||  find sym false ($,nontstates,$) nucleus =
	    lookup nucleus (assoc_sym sym nontstates)
    end

end
