--    lmlseek, main program
--    Author:  Mikael Rittri, Informationsbehandling,
--			      Chalmers Tekniska Hogskola,
--			      S-412 96 Goteborg, Sweden
--	       rittri@cs.chalmers.se
--
--    There should be a user manual called manual.tex in the same
--    directory as this file
--
--
#include "lextenv.t"	/* lexical analyzer for libraries */
#include "lextexp.t"	/* the same for type expr'ns */
#include "show.t"	/* prettyprinters */
#include "texp.t"	/* parser for type expr'ns */
#include "tenv.t"	/* parser for libraries */ */
#include "unlextenv.t"	/* unlexer for library tokens */
#include "unlextexp.t"	/* unlexer for type tokens */
#include "OK"		/* standard type */
#include "eqts.t";

#define Tenv (List((List Char)#Texp))

let rec
    typeenv = case  parse_tenv (lextenv input) 
	      in  Yes lib : lib
	      ||  No tokens : fail ("Couldn't parse library at: " @
			             head 80 (concmap unlextenv tokens))
	      end
and
    add_normal_form (name, typ) = ((name, typ), chtype (red typ))
and 
    founds =(map (\arg. 
		   let nf = 
		       (chtype 
			  (red 
			     (case parse_texp (lextexp arg)
			      in Yes texp : 
				    texp
			      || No tokens : 
				    fail ("Couldn't parse query at" @ 
					  concmap unlextexp tokens)
			      end))
			    : Bag Factor
			    )
		   in let filt = (filter (eqnfschemes nf o snd)
				 : List(*a#(Bag Factor)) -> 
				   List(*a#(Bag Factor))
				 )
		   in  map fst (filt 		
				     (map add_normal_form typeenv))
		 )
		 argv) : (List Tenv)
in
    map (  (\te. show_tenv te @ "\n\n")
	)
        founds
