-- gdc.m : Graphical Dialogue Combinators module
-- 
-- Started 21.7.88
-- By A.Dwelly
--
-- Modified 13.9.88 to operate with the Munich graphics model.

module

#include "ps.t"
#include "munout.t"
#include "munin.t"

infix "~>";

export DlgCombType,Dialogue,Do,Join,Cond,
       Seq,Id,Forever,While,Until,During,Case,~>,ExitCase,
       Otherwise,IsMouseClick,IsMsDep,IsClockTick,IsMs,IsAllMs,
       IsMsEn,IsMsEnN,IsMsExN,IsMsEx,IsMsMv,IsKbd,IsReceive,
       NullDialogue,RejectInput,Send,MapSend,Set,
       When,
       MsInterest,AllMsInterest,MsEnInterest,MsExInterest,
       MsMvInterest,KbdInterest,WaitForClick,Print;

rec
type DlgCombType *st = DC (List Char) *st (List EventType) +
		       Dummy

-- The basic operators of the dialogue combinators...

and Dialogue d st l =
	let DC Out St Rest = d st (Events l)
	in LoadMunich @ Out

and Do sf d st l = d (sf st) l

and Join d1 d2 st l =
    let rec DC Out1 St1 Rest1 = d1 st l
    and     DC Out2 St2 Rest2 = d2 St1 Rest1
    in DC (Out1 @ Out2) St2 Rest2

and Cond c dtrue dfalse st l =
    if c st l then dtrue st l else dfalse st l

-- Some higher level definitions

and Seq [] = NullDialogue
||  Seq (dh.dt) = Join dh (Seq dt)

and Id x = x

and Inf n = n.Inf n

and Forever = Seq o Inf

and While c d = Cond c (Join d (While c d)) NullDialogue

and Until c d = Cond c NullDialogue (Join d (Until c d))

and During c dstart dcont dstop = Seq [dstart; While c dcont; dstop]

and Case [] = RejectInput
||  Case ((c,d).t) = Cond c d (Case t)

and ExitCase c d = While c (Case d)

and c ~> d = (c,d)

-- A set of useful conditions

and Otherwise st l = true

and IsMs b a c st (Ms bp ap n crds .t) = (c = n) & (b = bp) & (a = ap)
||  IsMs b a c st l = false

and IsMsDep b st (Ms bp Dep n crds .t) = (b = bp)
||  IsMsDep b st l = false

and IsAllMs b a st (AllMs bp ap cn crd.t) = (b = bp) & (a = ap)
||  IsAllMs b a st l = false

and IsMsEn st (MsEn n x y.t) = true
||  IsMsEn st l = false

and IsMsEx st (MsEx n x y.t) = true
||  IsMsEx st l = false

and IsMsEnN m st (MsEn n x y.t) = m = n
||  IsMsEnN m st l = false

and IsMsExN m st (MsEx n x y.t) = m = n
||  IsMsExN m st l = false


and IsMsMv st (MsMv n x y.t) = true
||  IsMsMv st l = false

and IsKbd ch st (Kbd n a .t) = chr a = ch
||  IsKbd ch st l = false

and IsMouseClick st (Ms b a n crds .t) = true
||  IsMouseClick st l = false

and IsClockTick st (Tick . t) = true
||  IsClockTick st l = false

and IsReceive s (AppMess str .t) = true
||  IsReceive s l = false

-- Graphical Combinators

and NullDialogue st l = DC [] st l

and RejectInput s (h.t) = DC [] s t

and Send x s l = DC x s l

and MapSend [] = NullDialogue
||  MapSend (h.t) = Join (Send h) (MapSend t)

and Set newst oldst = newst

and When c d = Join (Until c RejectInput) d

and MsInterest b a n = Send (InMs b a n) 

and AllMsInterest b a n = Send (InAllMs b a n)

and MsEnInterest n = Send (InMsEn n)

and MsExInterest n = Send (InMsEx n)

and MsMvInterest n = Send (InMsMv n)

and KbdInterest n = Send (InKbd n)

and WaitForClick = Until IsMouseClick RejectInput

and Print s = Send (ConsolePrint s) 
end
