-- muntest4gr.m
--
-- The Munich graphics model, implemented in NeWS
--
-- By Andrew Dwelly (C) 1988 ECRC gmbh Munich
-- Version 0.1 1.9.88
--
-- Rubik's cube demo

module

#include "ps.t"
#include "munout.t"
#include "munin.t"

export BoxAnimate,
       DrawBackground,DrawCube,DrawPanel,DrawChangedFaces,DrawConfirm,
       KillConfirm,Button1,Button2,Button3,Yes,No;

rec     DrawCube = DrawFace 1 101 0 Red @
		   DrawFace 10 102 120 Blue @
		   DrawFace 19 103 240 MediumAquamarine @
		   DrawZArrows @ DrawXArrows @ DrawYArrows

and     BoxAnimate = Animate Screen 0 (100^100) (Ghost (Rect (700^500))) @
		     InAllMs Lft Dep Screen

and     DrawBackground pos = 
	  OpenPopWindow Background pos (700^500) Screen LightGray

and     DrawPanel =
           OpenWindow Panel (50^50) (150^400) Background White @
	   Bitmap Panel (4^250) (142^142) "oak.im8" @
	   DrawButton Button1 (10^10) (130^60) Panel White "Quit" @
	   DrawButton Button2 (10^90) (130^60) Panel White "Reset" @
	   DrawButton Button3 (10^170) (130^60) Panel White "Invert"

and     DrawButton but pos (Cart w h) prnt col str =
	   OpenOutlineCanvas but pos (0^0) 0 (100^100) 8 prnt col 
	   (RoundRect (Cart w h) 20) @
	   CentredText but (Cart (w/2) (h/2)) HelveticaBold 30 Black str @
	   ChangeCursor but Bullseye @
	   InMs Lft Dep but

and     DrawFace frm pr rot col =
           OpenCanvas pr (500^300) (500^300) rot (60^60) Background Black Face @
           DrawCubie pr (frm+0) (0^0) col @ 
           DrawCubie pr (frm+1) (87^50) col @ 
           DrawCubie pr (frm+2) (174^100) col @ 
           DrawCubie pr (frm+3) (Minus 87^50) col @ 
           DrawCubie pr (frm+4) (0^100) col @ 
           DrawCubie pr (frm+5) (87^150) col @
           DrawCubie pr (frm+6) (Minus 174^100) col @ 
           DrawCubie pr (frm+7) (Minus 87^150) col @ 
           DrawCubie pr (frm+8) (0^200) col  

and     DrawCubie pr n org col = OpenCanvas n org (0^0) 0 (100^100) pr col Cubie 

and     DrawZArrows = DrawZArrow 50 (240^215) @ DrawZArrow 51(240^275) @
		      DrawZArrow 52 (240^335)

and     DrawZArrow n org = 
	   OpenCanvas n org (0^0) 0 (300^300) 100 Black ZArrow @
	   InMs Lft Dep n @ InMs Mid Dep n @
	   ChangeCursor n Crosshair

and     DrawXArrows = DrawXArrow 53 (350^90) @ DrawXArrow 54 (400^58) @
		      DrawXArrow 55 (450^26) 

and     DrawXArrow n org =
           OpenCanvas n org (0^0) 0 (300^300) 100 Black XArrow @
	   InMs Lft Dep n @ InMs Mid Dep n @
	   ChangeCursor n Crosshair


and     DrawYArrows = DrawYArrow 56 (520^26) @ DrawYArrow 57 (570^58) @
                      DrawYArrow 58 (620^90) 

and     DrawYArrow n org = 
	   OpenCanvas n org (0^0) 0 (300^300) 100 Black YArrow @
	   InMs Lft Dep n @ InMs Mid Dep n @
	   ChangeCursor n Crosshair
 
and     DrawConfirm =
	   OpenPopWindow ConfirmPanel (100^100) (250^150) Background White @
	   CentredText ConfirmPanel (125^125) HelveticaBold 30 Black 
	   "Are you sure ?" @
	   DrawButton No (35^10) (90^90) ConfirmPanel Red "No!!" @
	   DrawButton Yes (135^10) (90^90) ConfirmPanel SpringGreen "Yes"

and     KillConfirm = RevokeMs Lft Dep Yes @ KillCanvas Yes @
		      RevokeMs Lft Dep No @ KillCanvas No @
		      KillCanvas ConfirmPanel

and     DrawChangedFaces n (oh.ot) (nh.nt) =
           if n = 28 then []
	   else if oh = nh then DrawChangedFaces (n+1) ot nt
	   else Fill n nh @ DrawChangedFaces (n+1) ot nt

-- Shapes used in this program

and     Face = Diamond (0^0) 300 30

and     Cubie = Diamond (0^0) 96 30

and     ZArrow = Ngon [10^15; 0^30; 10^30; 10^27; 20^21; 20^24; 30^9;
		       20^9; 20^12; 10^18; 10^15]

and     XArrow = Ngon [6^0; 0^10; 2^9; 2^19; 0^20; 6^30; 12^15; 10^16; 10^6;
		       12^5; 6^0]

and     YArrow = Ngon [6^0; 0^5; 2^6; 2^16; 0^15; 6^30; 12^20; 10^19;
                       10^9; 12^10; 6^0]

--------------
-- Canvases --
--------------

and     Background = 100

and     Panel = 120

and     SubPanel = 121

and     Button1 = 150

and     Button2 = 151

and     Button3 = 152

and     ConfirmPanel = 200

and     No = 201

and     Yes = 202

end
