-- muntest7.m
--
-- The Munich graphics model, implemented in NeWS
--
-- By Andrew Dwelly (C) 1988 ECRC gmbh Munich
-- Version 0.1 1.9.88
--
-- LML does typesetting.

#include "ps.t"
#include "munout.t"
#include "munin.t"
#include "fonts.t"
#include "gdc.t"

-------------------------
-- Dialogue definition --
-------------------------

let rec
    TypeSet = Seq [Initialise; SetType TestPage;
		   MsInterest Lft Dep Paper; WaitForClick]

and SetType str = Send (SubSetType (10^450) (BreakIntoWords "" str))

and SubSetType pos [] = []
||  SubSetType pos (h.t) = 
       let rec (Command,NewPos) = PrintIt pos h
       in Command @ SubSetType NewPos t

and PrintIt (Cart cx cy) str =
       let Wdt = StringWidth Helvetica 18 str
       in if cx + Wdt > 500 
       then (Text Paper (10^(cy-20)) Helvetica 18 Black str,((10+Wdt)^(cy-20)))
       else (Text Paper (cx^cy) Helvetica 18 Black str,((cx+Wdt)^cy))

and BreakIntoWords s [] = [reverse s]
||  BreakIntoWords s (h.t) = if h = ' ' then reverse (h.s).BreakIntoWords "" t
			     else BreakIntoWords (h.s) t

and Initialise = Seq [Send BoxAnimate; WaitForDepress; Open]

and BoxAnimate = Animate Screen 0 (100^100) (Ghost (Rect (550^500))) @
		 InAllMs Lft Dep Screen

and WaitForDepress =
       Cond (IsAllMs Lft Dep) NullDialogue (Join RejectInput WaitForDepress)

and Open s (AllMs Lft Dep cn pos. t) =
       DC (RevokeAllMs Lft Dep @ RevokeAnimate @ DrawPaper pos) s t

and DrawPaper pos = OpenPopWindow Paper pos (550^500) Screen White

and TestPage = "Thequick brown fox jumped over the lazy dog to a bush. 123456789; I Wondered lonely as a cloud, or a butterfly or something, anyway, I happened to spy a couple ;;;;;; of daffs."

and Paper = 1

in Dialogue TypeSet [] input

