-- 
-- Started 21.7.88
-- By A.Dwelly
--
-- Modified 13.9.88 to operate with the Munich graphics model.

module

export TreeType,NewTree,AddChild,DelChild,DepthTraverse,NodeNum,NodeObj,
       Root,Parent,Child,EBro,YBro,EldestBro,EldestChild,YChildNum,ChildWithNum,
       TreeFind;

rec
type TreeType *a = Tree Int *a (TreeType *a) (TreeType *a)
				   (TreeType *a) (TreeType *a) +
		       Empty

and NewTree a = Tree 0 a Empty Empty Empty Empty

and AddChild a c p tree =
    let (Sig,T) = SubAddChild a c p tree
    in if Sig then T
       else fail ("Unable to find parent " @ itos p)

and SubAddChild a c p Empty = (false,Empty)

||  SubAddChild a c p (Tree n b up Empty left right) = 
    let rec Parent = Tree n b up Child left right
    and     Child  = Tree c a Parent Empty Empty Empty
    and    (Sig,T) = SubAddChild a c p right
    in if p = n then (true,Tree n b up Child left right)
       else (Sig,Tree n b up Empty left T)

||  SubAddChild a c p (Tree n b1 up (Tree m b2 u d l r) left right) = 
    let rec Parent = Tree n b1 up Child left right
    and     Brother = Tree m b2 u d Child r
    and     Child  = Tree c a Parent Empty Empty Brother
    and  (Sig1,T1) = SubAddChild a c p (Tree m b2 u d l r) 
    and  (Sig2,T2) = SubAddChild a c p right
    in if p = n then (true,Tree n b1 up Child left right)
       else if Sig1 then (true,Tree n b1 up T1 left right)
	    else (Sig2,Tree n b1 up (Tree m b2 u d l r) left T2)

and DelChild c Empty = Empty
||  DelChild c (Tree n b u d l r) =
      let rec PointToLeft nl Empty = Empty
      ||      PointToLeft nl (Tree n b u d l r) = Tree n b u d nl r
    in if n = c then PointToLeft l r
    else Tree n b u (DelChild c d) l (DelChild c r)

and DepthTraverse f Empty = []
||  DepthTraverse f (Tree n b up down left right) =
    f (Tree n b up down left right) @ DepthTraverse f down @ DepthTraverse f right

and NodeNum (Tree n b up down left right) = n
||  NodeNum Empty = 100000

and TreeFind n Empty = Empty
||  TreeFind n (Tree m b up down left right) = 
     if m = n then Tree m b up down left right
     else if TreeFind n down = Empty then TreeFind n right
	  else TreeFind n down

and NodeObj (Tree n b up down left right) = b

and Root (Tree n b up down left right) = Tree n b up down left right

and Parent (Tree n b up down left right) = up

and Child (Tree n b up down left right) = down

and YBro (Tree n b up down left right) = left

and EBro (Tree n b up down left right) = right

and EldestBro (Tree n b up down left Empty) = Tree n b up down left Empty
||  EldestBro (Tree n b up down left right) = EldestBro right

and EldestChild t = EldestBro (Child t)

and YChildNum 0 t = Child t
||  YChildNum n t = EBro (YChildNum (n-1) t)

and ChildWithNum n Empty = Empty
||  ChildWithNum n (Tree m b u d l r) = if n = m then Tree m b u d l r
                                        else ChildWithNum n r
end
