#include "stream.t"
#include "sim.t"
#include "seq.t"
#include "alu.t"
#include "count.t"
#include "decode.t"
#include "latch.t"
#include "memory.t"
#include "datasel.t"
#include "parsecode.t"
#include "timing.t"
#include "output.t"
#define DELAY 2
let rec 
	Clock = Oscft 10 10
and	Wpulse = (Srep false 12 (Osctf 6 14))
and	(Imed,Rreg,Wreg,Jadr,Jcond) =
	    let rec a = rom (hd argv) DELAY Nextadr
	    and    im ((i,$,$,$,$)::r) = i::im r
	    and	   rr (($,i,$,$,$)::r) = i::rr r
	    and    wr (($,$,i,$,$)::r) = i::wr r
	    and    ja (($,$,$,i,$)::r) = i::ja r
	    and    jc (($,$,$,$,i)::r) = i::jc r
	    in (im a,rr a,wr a,ja a,jc a)

and	Nextadr = seq DELAY (Smap not Clock) Jcond Aluf Jadr
and	(Walura.Walurb.Wr0.Wr1.Wr2.Woutput.Walufr.$) =
		OneOfEight DELAY Wreg Wpulse
and	Bus = datasel DELAY [Alur;Imed] Rreg
and	Alura = latch DELAY Walura Bus 
and	Alurb = latch DELAY Walurb Bus
and	Alufr = latch DELAY Walufr Bus
and	R0 = latch DELAY Wr0 Bus
and	R1 = latch DELAY Wr1 Bus
and	R2 = latch DELAY Wr2 Bus
and	(Alur,Aluf) = alu DELAY Alufr Alura Alurb

in timing [Clock;Wpulse;Walura;Walurb]
	  ["Clock";"Write pulse";"Write alu reg A";"Write alu reg B"]
	  [Bus;Alura;Alurb;Alur]
	  ["Bus";"Alu reg A";"Alu reg B";"Alu result"]
	  Clock (stoi (hd (tl argv)))
