module
-- Change method selection of known class vectors into the selected
-- component.
#include "../expr/id.t"
#include "../expr/id.t.t"
#include "../expr/constrfun.t"
#include "../misc/flags.t"
#include "../misc/misc.t"
#include "../rename/renenv.t"
#include "../rename/import.t"
#include "Expr.t.t"
#include "Eutil.t"
#include "../funnos.h"
export classtrans;

rec classtrans e = if Curry then cltr e else e

and cltr (Emodule i expl dl) = 
        let dl' = map (mapsnd clt) dl in
    	Emodule i expl dl'
and
    clt (Eap e1 e2) = Eap (clt e1) (clt e2)
||  clt (Ecase e1 cl e2) = Ecase (clt e1) (mapthd clt cl) (clt e2)
||  clt (Elet r dl e) = Elet r (mapsnd clt dl) (clt e)
||  clt (Econstr c el) = Econstr c (map clt el)
||  clt (Efailmatch n) = Efailmatch n
||  clt (Eidapl i es) = chkmet i (map clt es)
||  clt (Elamapl is e es) = Elamapl is (clt e) (map clt es)
||  clt (Einfo f e) = Einfo f (clt e)
and chkmet (mkid os _ (idi_method [k] _ (clsi c _ sis _ sm)) _) 
           (Eidapl (mkid _ _ (idi_inst _ mis _) _) xs.es) =
	if (length mis >= k) then
	    constconv (select (k+sm+1) mis) (xs@es)
	else
	    fail "bad method number in chkmet"
-- transform method application into a call to the vector with the method number
||  chkmet (mkid _ _ (idi_method [k] _ (clsi _ _ sis _ sm)) _) (Eidapl i xs . ys) =
    Eidapl i (xs @ [Emkint (k+sm)] @ ys)
||  chkmet i es = Eidapl i es


and vf s = rfind Kvalue s preenv
and IfromI = vf "MM.Num.Integer.fromInteger"
and ifromI = vf "MM.Num.Int.fromInteger"
and FfromR = vf "MM.Fractional.Float.fromRational"
and DfromR = vf "MM.Fractional.Double.fromRational"
and ItoI   = vf "MM.Real.Integer.toInteger"
and FfromI = vf "MM.Num.Float.fromInteger"
and DfromI = vf "MM.Num.Double.fromInteger"
and constconv i [e as Econstr c []] =
             if eqid IfromI i & isinteger c then e
        else if eqid ItoI   i & isinteger c then e
	else if eqid ifromI i & isinteger c then Emkint (stoi (cname c))
        else if (eqid FfromI i | eqid DfromI i) & isinteger c then Econstr (mkfloat (butlast (cname c))) []
        else if (eqid FfromR i | eqid DfromR i) & isrational c then Econstr (mkfloat (cname c)) []
        else Eidapl i [e]
||  constconv i es = Eidapl i es
end
