module -- parse
-- parse and translate one line
#include "../mcode/mcodedef.t.t"
export parse;
rec
    addr ["Vp"]			= Vp
||  addr ['$'.n;"(";"Vp";")"]	= Vrel (stoi n)
||  addr [n;"(";"Vp";")"]	= Vind (stoi n)
||  addr ["Vpush"]		= pushV
||  addr ["Vpop"]		= popV
||  addr ["Sp"]			= Sp
||  addr ['$'.n;"(";"Sp";")"]	= Srel (stoi n)
||  addr [n;"(";"Sp";")"]	= Sind (stoi n)
||  addr ["Spush"]		= pushS
||  addr ["Spop"]		= popS
||  addr ["Hp"]			= hp
||  addr ['$'.n;"(";"Hp";")"]	= hprel (stoi n)
||  addr [n;"(";"Hp";")"]	= hpind (stoi n)
||  addr ["toH"]		= tohp
||  addr ['r'.r as (c._)] & (isdigit c)= reg (stoi r)
||  addr ['$'.n;"(";'r'.r;")"]	= regrel (stoi r)(stoi n)
||  addr [n;"(";'r'.r;")"]	= regind (stoi r) (stoi n)
||  addr ['$'.s as (c._)] & (isdigit c | c='-') = const (stoi s)
||  addr ['#'.s]		= retaddr s
||  addr ['$'.s]		= idlit s
||  addr [s as c._] & (isdigit c | c='-') = const (stoi s)
||  addr ['@'.s]		= glob s
||  addr [s]			= glob s
||  addr s			= fail ("addr"@mix s ",")
and tag "oeval"		= oeval
||  tag "ounwind"	= ounwind
||  tag "ojfun"		= ojfun
||  tag "omkapl"	= omkapl
||  tag "ogettag"	= ogettag
||  tag "ogc"		= ogc
||  tag "ocmp"		= ocmp
||  tag "oprint"	= oprint
||  tag "onb"		= onb
||  tag "onp"		= onp
||  tag "oargs"		= oargs
||  tag "ovno"		= ovno
||  tag "ospark"	= ospark
and cc "eq"		= eq
||  cc "ne"		= ne
||  cc "lt"		= lt
||  cc "gt"		= gt
||  cc "le"		= le
||  cc "ge"		= ge
||  cc "lts"		= ltstack
||  cc "lth"		= ltheap
||  cc "gts"		= gtstack
||  cc "geh"		= geheap
and ops = map addr o choplist (splitat ",")
and mop opr r = let [a;b;c] = ops r in [Mop3 opr a b c]
and mop2 opr r = let [a;b] = ops r in [Mop2 opr a b]
and stripq (_.s) = (f s
	where rec f ['"']        = []
	       || f ('\\'.'n'.s) = '\n'.f s
	       || f (c       .s) = c   .f s)

and parse (l.":".r) = Mlabel l.parse r
||  parse [".data"] = [Mdata]
||  parse [".text"] = [Mtext]
||  parse [".export";s] = [Mexport s]
||  parse [".string";s] = [Mstring (stripq s)]
||  parse (".word".ws) = map Mword (ops ws)
||  parse [".malign"] = [Malign]
||  parse [".funbegin";s] = [Mfunbegin s]
||  parse [".funend"] = [Mfunend]
||  parse [".asm";a] = [Masm (stripq a) []]
||  parse (".asm".a.",".args) = [Masm (stripq a) (ops args)]
||  parse ["call"; s] = [Mcall s]
||  parse ["jump"; s] = [Mjump s]
||  parse ["jumpf"; s] = [Mjumpf s]
||  parse ["return"] = [Mreturn]
||  parse ("move".r) = let [s;d] = ops r in [Mmove s d]
||  parse ["call";t;"(";'r'.r;")"] = [Mcalltag (tag t) (stoi r)]
||  parse ["jump";t;"(";'r'.r;")"] = [Mjumptag (tag t) (stoi r)]
||  parse ("comp".r) = let [s;d] = ops r in [Mcompare s d]
||  parse ("add".r) = mop add r
||  parse ("sub".r) = mop sub r
||  parse ("mul".r) = mop mul r
||  parse ("div".r) = mop div r
||  parse ("mod".r) = mop mod r
||  parse ("add2".r) = mop2 add r
||  parse ("sub2".r) = mop2 sub r
||  parse ("mul2".r) = mop2 mul r
||  parse ("div2".r) = mop2 div r
||  parse ("mod2".r) = mop2 mod r
||  parse ("case".x) =
	let (a.y) = choplist (splitat ",") x in
	let (l.h.m.r) = map hd y in
	[Mcase (addr a) (stoi l) (stoi h) (stoi m) r 0] -- bad
||  parse ("boolcc".c.",".r) = let [d] = ops r in [Mboolcc (cc c) d]
||  parse ['j'.c; s] = [Mjcond (cc c) s]
||  parse [""] = []
||  parse [] = []
||  parse r = [Mcom ("Strange:"@(mix r " "))]
end
