--
-- $Header: /ufs/usr.src/local/lml/src/rename/RCS/renameutil.m,v 97.0 90/07/07 14:41:56 augustss Exp $
--
module -- rename
--
-- This module contains various functions used in rename.

#include "../expr/id.t.t"
#include "../expr/constr.t.t"
#include "../expr/ttype.t.t"
#include "../expr/einfo.t.t"
#include "../expr/types.t.t"
#include "../expr/id.t"
#include "../expr/ttype.t"
#include "../expr/error.t"
#include "../expr/impexp.t.t"
#include "../expr/impexp.t"
#include "../expr/tinfo.t"
#include "../expr/pprint.t"
#include "../misc/misc.t"
#include "../misc/flags.t"
#include "renenv.t"
#include "../transform/misc.t"
#include <OK>
#include <Option>

export sdef, mid, newident, isconstri, ismulti, addc, getcs,
	etag, findid, getimpid, renexplist, listify, flatsyns,
	isexpid, impid, isimpimport, istypeish, isval, hrenexplist, mkff, mkffv, addmets, buildinstid, buildmets, cliof, badid;
rec

    sdef i e = mkbpat [(mkident i, e)]
and mid s (u, i) = mkid u s i
and newident n = mkident (mknewid "T" n)
and isconstri env (mkids s) = 
	case rfind Kvalue s env in
	    mkid _ _ (idi_constr _ _ _ _) _ : true
	||  _ : false
	end
||  isconstri env i = id_isconstr i
and ismulti cp p =
	case leftmost p in
	    mkconst _ : true
        ||  mkident i : cp i
	||  mkas _ _  : true
	||  mkinfo _ p : ismulti cp p
        ||  e : fail ("Weird pattern "@ppr e)
	end
and addc cs cp x = mem x cs | cp x
and getcs (mkbrec d) = getcs d
||  getcs (mkband d1 d2) = getcs d1 @ getcs d2
||  getcs (mkblocal d1 d2) = getcs d2
||  getcs (mkbtype _ ats _) = map (\(mkcons c _).c) ats
||  getcs _ = []
and etag ff l u i = (rlist Kvalue (map2 tagid l (from u))
	where tagid (mkids s) n = let rec ii = mkid n s i (ff ii) in ii
	||    tagid (i as mkid _ s _ _) _ = i)
and getimpid (mkimpid i _ _) = i
and findid s env cont =
	    case rfind Kvalue s env in
	       mkid 0 _ _ _ : mkerror("Undefined identifier " @ tl s)
	    || id : cont id
	    end

and renexplist expl denv = reduce (\s.\(er, ex).
	case rfind Kall s denv in
	    mkid 0 _ _ _ : (("Export id "@s@" not defined").er, ex)
	||  (id as mkid no _ (idi_type _ _ ti _ _) _) :
		let cs = map (\(mkcons i _).mkexpid i) (get_cs_from_tinfo ti) in
		(er, mkexpid id.cs @ ex)
	||  id : (er, mkexpid id.ex)
	end)
	([], [])
	expl
and hrenexplist expl denv =
    let cs = 
        map
        (\e.
	case e in
	    mkexpid s : chk mkexpid [Kvalue; Ktype] s denv
        ||  mkexpidall s : chk mkexpidall [Ktype] s denv
	||  mkexpidsome s is :
	    case chk mkexpidall [Ktype] s denv in
	        (x as Yes (mkexpidall (mkid _ _ (idi_type _ _ ti _ _) _))) :
		    if sort (<) (map idtostr is) = sort (<) (map (\(mkcons i _).idtostr i) (get_cs_from_tinfo ti)) then
			x
		    else
			No ("Exported constructors for "@oprid s@" does not match definition")
	    ||  (x as Yes (mkexpidall (mkid _ _ (idi_class (clsi _ iits _ _ _)) _))) :
		    if sort (<) (map idtostr is) = sort (<) (map (\(_,i,_).idtostr i) iits) then
			x
		    else
			No ("Exported methods for "@oprid s@" does not match definition")
	    ||  x : x
            end
	||  mkexpidmodall s : chk mkexpidmodall [Kmodule] s denv
	end)
	expl in
    reduce clsfy ([],[]) cs
and clsfy (Yes x) (e,i) = (e, x.i)
||  clsfy (No s)  (e,i) = (s.e, i)
and chk f [] s env = No ("Export id "@oprid s@" not defined")
||  chk f (k.ks) s env = 
        case rfind k (idtostr s) env in
	    mkid 0 _ _ _ : chk f ks s env
        ||  i : Yes (f i)
        end
and listify (mkband b1 b2) = listify b1 @ listify b2
||  listify (mkbnull) = []
||  listify b = [b]
and flatsyns ss = concmap (\(mkbsign ids t).map (\id.(id, t)) ids) ss
and isexpid (mkexpid _) = true
||  isexpid _ = false
and impid (mkimpid i _ _) = i
||  impid (mkimptype t _ _) = tname t
||  impid (mkimpeqtype t _ _) = tname t
||  impid (mkimpsyn t _) = tname t
||  impid (mkimpclass (mkcdecl _ (mkassert ci _)) _) = ci
||  impid (mkimpinstance (mkidecl _ ci ti _) _) = ci
||  impid (mkimpimport i _ _) = i
and isimpimport (mkimpimport _ _ _) = true
||  isimpimport _ = false
and istypeish (mkimptype _ _ _) = true
||  istypeish (mkimpeqtype _ _ _) = true
||  istypeish (mkimpsyn _ _) = true
||  istypeish (mkimpclass _ _) = true
||  istypeish _ = false
and isval (mkimpid _ _ _) = true
||  isval (mkimpids _ _ _) = true
||  isval _ = false
-- Inefficient because there is no full lazyness!!
and mkff v (mkids m) fixs id = 
    let s = idtostr id in
    Orignames v
              (assocdef s (concmap (\(mkfixid ids f).map (\i.(idtostr i, f)) ids) fixs) Nofixity) 
              [m; s]
and mkffv (mkids m) fixs exps id = 
    let s = idtostr id in
    Orignames (if member eqid id exps then Vexported else Vprivate)
              (assocdef s (concmap (\(mkfixid ids f).map (\i.(idtostr i, f)) ids) fixs) Nofixity) 
	      [m; s]

-- The idi_inst id is used to collect info about instances and also serves as the id of the instance
-- method vector.  It has to contain the names of all the instance operators
-- reserve numbers for both methods, and functions in the method vector.
and buildinstid ff u (mkidecl k ci ti vs) tn flg =
    let u = u+1 + length k in
    let nci = iclsname tn
    and nti = ityname tn in
    let vis = if id_is_visible nci | id_is_visible nti then Vexported else Vprivate in -- Not correct!!!
    let s = vecstr ci (mktcons ti (map mktvar vs)) in
    let rec ii = (mkid u s (idi_inst tn [] flg) (ff ii)) in 
    (updvis vis ii, u+length (cliof tn)+1)

and buildmets (ii as mkid u s (idi_inst t _ _) (onn as Orignames v f on)) =
    let! (mkidecl k ci ti vs) = t in
    let it = mktcons ti (map mktvar vs) in
    let mids = 
    map2 (\(d,m,t).\u.let s = methstr ci (mktcons ti (map mktvar vs)) m in 
		      let! (mktcontype [mkassert _ tv] tt) = t in
		      let tr = tsub tv it tt in
	              mkid u s (idi_var (var_global f_unk) 
			       (Ohastype tr (getTvars tr))) 
			       (Orignames v f (butlast on @ [s]))) 
	 (cliof t) (from (u+1))
    in mkid u s (idi_inst t mids false) onn
||  buildmets i = i
and tsub v tr t = Typerec (\x.if x = v then tr else mktvar x) mktcons t
and cliof (mkidecl _ (mkid _ _ (idi_class (clsi _ cli _ _ _)) _) _ _) = cli
||  cliof _ = []		-- Can happen during erroneous declarations.
--||  cliof t = fail ("cliof "@pridecl t)
and vecstr ci t = "VV."@tl (idtostr ci)@"."@flatstr t
and methstr ci t oi = "MM."@tl (idtostr ci)@"."@flatstr t@"."@tl (idtostr oi)
and flatstr (mktcons ti ts) = tl (idtostr ti) @ concmap (\t.'~'.flatstr t) ts
||  flatstr (mktvar _) = "a"

and metids (mkid _ _ (idi_inst _ is _) _) = is
||  metids _ = []
and addmets r =
    let rn = rmapfilter Ktype (Some o buildmets) r in
    let mids = concmap metids (rids Ktype rn) in
    rjoin (rlist Kvalue mids) rn

-- Check if an id conforms to the stupid Haskell rules.
and badid i = xor (cap i) (needcap i)
and xor true false = true
||  xor false true = true
||  xor _ _ = false
and cap (mkid _ (_.c._) _ _) = c = ':' | isupper c
and needcap (mkid _ _ (idi_var _ _) _) = false
||  needcap _ = true
end
