extern int PROCESSNO[];
extern int TOFILEA[], TOFILE[], TOSTDOUT[], TOSTDERR[], TOFILE3[], TOFILE4[],
           CCFLUSH[], HIATON[], CCBREAK[], CCOOKED[], CHIATON[], CUNBUFF[], TONEWS[],
           CMHIATON[], CDELAY[], CINTRON[], CINTROFF[];
FILE *ofiles[10] = { 0, stdout, stderr };
extern int **mknode();

#define MIN(x,y) ((x)<(y) ? (x) : (y))

#define SETT(p, t) ((p)->tv_sec = (t)/1000, (p)->tv_usec = (t)%1000 * 1000)

int
hread(f)
FILE *f;
{
#ifdef SYSV
    return 0;
#else
    int i, imask, n;
    long d;
    struct timeval tv;
    static int firsttime = 1;
    static struct timeval lasthiaton;

    if (f->_cnt > 0)
	return getc(f);
    imask = 1<<fileno(f);
    if (MergeHiaton) {
	if (firsttime) {
	    SETT(&tv, Ttime);
	    firsttime = 0;
	} else {
	    gettimeofday(&tv, (struct timeval *)0);
	    d = (tv.tv_sec - lasthiaton.tv_sec)*1000 + 
		(tv.tv_usec - lasthiaton.tv_usec)/1000;
	    d = Ttime - d;
	    if (d <= 0)
		d = 1;
	    SETT(&tv, d);
	}
    } else {
	SETT(&tv, Ttime);
    }
    n = select(32, &imask, (int *)0, (int *)0, &tv);
    if (MergeHiaton) {
	if (n == 0) {
	    /* timeout has expired, produce hiaton and remember time */
	    gettimeofday(&lasthiaton, (struct timeval *)0);
	}
    }
    if (n == 1) {
	return getc(f);
    } else {
	return HIATON[1];
    }
#endif
}

int
readchar(f)
FILE *f;
{
    if(f == mystdin && Hflag)
	return hread(f);
    else
	return getc(f);
}

closefile(f)
FILE *f;
{
    if (debug) fprintf(stderr, "close\n");
    (void)fclose(f);
}

int **
evaluate(p)
int **p;
{
    *--ep = (int *)p;
    eval();
    return (int **)*ep++;
}

evalstring(s, cp, n)
int **s;
char *cp;
int n;
{

    --n;
    s = evaluate(s);
    while(s[0] == (int *)PAIR1){
	*--ep = (int *)s;		/* save in case of GC */
	(void)evaluate((int **)s[1]);
	s = (int **)*ep++;		/* restore */
	if (--n > 0)
	    *cp++ = s[1][1];
	s = evaluate((int **)s[2]);	/* eval tail */
    }
    *cp = '\0';
}

int **
openfile(s)
int  **s;
{
    extern int errno;
    extern char *sys_errlist[];
    char buf[1024];
    FILE *f;
    int **res;
    
    evalstring(s, buf, sizeof buf);
    if (debug) fprintf(stderr, "opening %s\n", buf);
    f = fopen(buf, "r");
    if(hp > ehp)
	gcstack(0);
    if(f == NULL){
	res = mknode(TAG, NIL, mknode(STRING, (int **)sys_errlist[errno], NIL));
    } else {
	res = mknode(TAG, (int **)1, mknode(INPUT, (int **)f, NIL));
    }
    return res;
}
