/*#define	oeval	0*/
/*#define	ounwind 1*/
/*#define	ojfun	2*/
/*#define	omkapl	3*/
/*#define	ogettag	4*/
/*#define	ogc	5*/
/*#define	ocmp	6*/
/*#define	oprint	7*/
/*#define	ospark	8*/
/*#define	ocanon	9*/
#define	onb	10
#define	onp	11
#define	ovno	12

; VFarity	the arity of the funtion
; VFpointer	pointer to function node
; VFunwind	after unwind, i.e. chk arg & rearrange
; VFcode	function code (after rearrange)
; VFvapunwind	unwind of vektor applikation
; VFstingy	pointer to stingy code, or 0 if not available
; VFlink	link field used during GC
; VFnref	number of entries in VFrefs
; VFrefs	table of references to global entities
#define VFarity	0
#define VFpointer	1
#define VFunwind	ojfun
#define VFcode	omkapl
#define VFvapunwind	ogettag
#define VFstingy	5
#define	VFlink	6
#define	VFnref	7
#define	VFrefs	8

; Reg          Type
; r0		AM	Misc
; r1		AM	Misc
; ARGCREG	DM	Argument count in jfun, callfun
; TAGREG	DM	Tag value from gettag
; BIGEQREG	DM	Return value fom bigeq
; INDREG	AM	Used in dispatch
; GCSTART	A	_startheap during GC
; GCEND		A	_endheap during GC
; GCCUR		A	_curheap during GC
; CRETR		D	return value from C
; DTMP		D	scratch
; CDTMP		D	scratch used only in bigcmp, must survive ogettag
;			usually DTMP
; ATMP		A	scratch
; FDISP		A	used in function node dispatch
;
; DTMP, ATMP must be distinct
; GCx must be distinct from all other regs when used
;
; A - Address register
; D - Data register
; M - Used in mcode generator

; LBASE			360 only
; CCALL(m,a)		Call C routine a with n arguments
; CENTRY		Entry code for C routine
; CRET			Return from C routine
; CARGn(a)		Get C argument n into a
; CPUSHARG(a)		Push C argument (before CCALL)
; DECR(d)		Decrement d
; TSTC(d)		Set condition code (if DECR&sub doesn't)
; ADDAW(c,d)		Add a word offset to an address
; ADDSP(c)		Add a word vount to sp
; ADDSP2(c,d)		Add a word count to sp, result in second op
; TABADDR(s,c,d)	Address of table entry c, 2 word/elem
; MOVIB(s,d)		Get a byte
; MASKB(d)		Byte mask
; INCBP(a)		Increment byte pointer
; TSTBIND(a)		Test byte indirect
; MCOUNTCALL		Call the profiling routine
; MCOUNTPOST		Reset after profiling has been called
; SETBIT(n,a)		Set  the nth bit in the word vector starting at a
; BITSUB(a,b,c)		bit set subtraction: c = b - a
; BITUNI(a,b,c)		bit union: c = b | a
; BITINT(a,b,c)		bit intersection: c = b | a
; JBITSET(m,a,l)	jump if bit set
; FADD3(a,b,c)		double precision 3-op add
; FSUN3(a,b,c)		double precision 3-op sub
; FMUL3(a,b,c)		double precision 3-op mul
; FDIV3(a,b,c)		double precision 3-op div
; FCOMP(a,b)		double precision compare
; FJGT(l)		jump after FCOMP
; FJLT(l)		jump after FCOMP
; FITOF(a,b)		integer to double
; FFTOI(a,b)		double to integer
; CPUSHFARG(a)		push a C double arg

#ifdef m_vax
	.asm	"	.set	ep,	r10"
	.asm	"	.set	hp,	r11"
	.asm	"	.set	oeval,	0"
	.asm	"	.set	ounwind,4"
	.asm	"	.set	ojfun,	8"
	.asm	"	.set	omkapl,	12"
	.asm	"	.set	ogettag,16"
	.asm	"	.set	ogc,	20"
	.asm	"	.set	ocmp,	24"
	.asm	"	.set	oprint,	28"
	.asm	"	.set	ospark,	32"

#define ARGCREG	r2
#define TAGREG r2
#define BIGEQREG r2
#define INDREG r9

#define GCSTART r5
#define GCEND r6
#define GCCUR r7
#define CRETR r0
#define DTMP r4
#define CDTMP DTMP
#define ATMP r2
#define FDISP r3

#define LBASE		; nothing
#define CCALL(m,a) 	.asm "	calls	^,^",m,a
#define CENTRY(m)	.asm "	.word	0xfff"
#define CRET		.asm "	ret"
#define CARG(m,a)	.asm "	movl	4*^+4(ap),^",@m,a
#define CPUSHARG(a)	.asm "	movl	^,-(sp)",a
#define DECR(a)		.asm "	decl	^",a
#define TSTC(a)		; CC already set
#define ADDAW(s,d)	.asm "	moval	(^)[^],^",d,s,d
#define ADDSP(c)	.asm "	moval	(%ep)[^],%ep",c
#define ADDSP2(c,d)	.asm "	moval	(%ep)[^],^",c,d
#define TABADDR(s,c,d)	.asm "	movaq	^[^],^",s,c,d
#define MOVIB(s,d)	.asm "	movzbl	(^),^",s,d
#define MASKB(s,d)	.asm "	movzbl	^,^",s,d
#define INCBP(p)	.asm "	incl	^",p
#define TSTBIND(r)	.asm "	tstb	(^)",r
#define MCOUNTCALL	.asm "	???"
#define MCOUNTPOST	.asm "	???"
#define SETBIT(m,a)	.asm "	movl	^,r6\n	clrl	r7\n	ediv	$32,r6,r6,r7\n	rotl	r7,$1,r7\n	bisl2	r7,^[r6]",m,a
#define JBITSET(m,a,l)	.asm "	movl	^,r6\n	clrl	r7\n	ediv	$32,r6,r6,r7\n	rotl	r7,$1,r7\n	bitl	r7,^[r6]\n	bneq	^",m,a,l
#define	BITSUB(a,b,c)	.asm "	bicl3	^,^,^",a,b,c
#define BITUNI(a,b,c)	.asm "	bisl3	^,^,^",a,b,c
#define BITINT(a,b,c)	.asm "	mcoml	^,r6\n	bicl3	r6,^,^",b,a,c
#define FADD3(a,b,c)	.asm "	addd3	^,^,^",a,b,c
#define FSUB3(a,b,c)	.asm "	subd3	^,^,^",a,b,c
#define FMUL3(a,b,c)	.asm "	muld3	^,^,^",a,b,c
#define FDIV3(a,b,c)	.asm "	divd3	^,^,^",a,b,c
#define	FCOMP(a,b)	.asm "	cmpd	^,^",a,b
#define FJGT(l)		jgt	l
#define FJLT(l)		jlt	l
#define FITOF(a,b)	.asm "	cvtld	^,^",a,b
#define FFTOI(a,b)	.asm "	cvtdl	^,^",a,b
#define CPUSHFARG(a)	.asm "	movd	^,-(sp)",a
#endif

#ifdef m_32000
	.asm	"	.set	oeval,	0"
	.asm	"	.set	ounwind,4"
	.asm	"	.set	ojfun,	8"
	.asm	"	.set	omkapl,	12"
	.asm	"	.set	ogettag,16"
	.asm	"	.set	ogc,	20"
	.asm	"	.set	ocmp,	24"
	.asm	"	.set	oprint,	28"
	.asm	"	.set	ospark,	32"

#define ARGCREG	r2
#define TAGREG r2
#define BIGEQREG r2
#define INDREG r3

#define GCSTART _startheap
#define GCEND _endheap
#define GCCUR _curheap
#define CRETR r0
#define DTMP r4
#define CDTMP r5
#define ATMP r2
#define FDISP r5

#define LBASE		; nothing
#ifdef SYSV
#define CCALL(m,a) 	.asm "	jsr	^\n	adjspb	$^*-4",a,m
#else
#define CCALL(m,a) 	.asm "	jsr	^\n	adjspb	-4*^",a,m
#endif
#define CENTRY(m)	.asm "	enter	[r3,r4,r5,r6,r7],0\n	sprd	fp,tos"
#define CRET		.asm "	lprd	fp,tos\n	exit	[r3,r4,r5,r6,r7]\n	ret	0"
#define CARG(m,a)	.asm "	movd	4*^+8(fp),^",@m,a
#define CPUSHARG(a)	.asm "	movd	^,tos",a
#define DECR(a)		.asm "	addqd	-1,^",a
#ifdef SYSV
#define TSTC(a)		.asm "	cmpd	^,$0",a
#else
#define TSTC(a)		.asm "	cmpd	^,0",a
#endif
#define ADDAW(s,t)	.asm "	addr	0(^)[^:d],^",t,s,t
#define ADDSP(c)	.asm "	addr	0(^)[^:d],^",Sp,c,Sp
#define ADDSP2(c,x)	.asm "	addr	0(^)[^:d],^",Sp,c,x
#define TABADDR(s,c,d)	.asm "	addr	^[^:q],^",s,c,d
#define MOVIB(s,d)	.asm "	movzbd	0(^),^",s,d
#define MASKB(s,d)	.asm "	movzbd	^,^",s,d
#define INCBP(p)	.asm "	addqd	1,^",p
#ifdef SYSV
#define TSTBIND(r)	.asm "	cmpb	0(^),$0",r
#else
#define TSTBIND(r)	.asm "	cmpb	0(^),0",r
#endif
#define MCOUNTCALL	.asm "	addr	4(sp),r4\n	lprd	fp,r4\n	jump	mcount"
#define MCOUNTPOST	.asm "	ret"
#define SETBIT(m,a)	.asm "	sbitb	^,^",m,a
#define JBITSET(m,a,l)	.asm "	tbitb	^,^\n	bfs	^",m,a,l
#define	BITSUB(a,b,c)	.asm "	movd	^,^\n	bicd	^,^",b,c,a,c
#define BITUNI(a,b,c)	.asm "	movd	^,^\n	ord	^,^",b,c,a,c
#define BITINT(a,b,c)	.asm "	movd	^,^\n	andd	^,^",b,c,a,c
#endif

#ifdef m_68000
	.asm "oeval=0"
	.asm "ounwind=4"
	.asm "ojfun=8"
	.asm "omkapl=12"
	.asm "ogettag=16"
	.asm "ogc=20"
	.asm "ocmp=24"
	.asm "oprint=28"
	.asm "ospark=32"

; r0-r7 <=> a0-a7 r8-r15 <=> d0-d7
; d1 is used as a scratch register, both here and in the code generator.
#define ARGCREG	r10
#define TAGREG r10
#define BIGEQREG r10
#define INDREG r4

#define GCSTART r14
#define GCEND r13
#define GCCUR r12
#define CRETR r8
#define DTMP r11
#define CDTMP DTMP
#define ATMP r2
#define FDISP r3

#define LBASE		; nothing
#define CCALL(m,a) 	.asm "	jsr	a\n	addl	^*4,^",m,Vp
#define CENTRY(m)	.asm "	link	a6,#-16\n	moveml	#0x3f3e,a7@-"
#define CRET		.asm "	moveml	a7@+,#0x7cfc\n	unlk	a6\n	rts"
#define CARG(m,a)	.asm "	movl	a6@(4*^+8),^",@m,a
#define CPUSHARG(a)	.asm "	movl	^,a7@-",a
#define DECR(a)		.asm "	subql	#1,^",a
#define TSTC(a)		; CC already set
#define ADDAW(s,d)	.asm "	movl	^,d1\n	asll	#2,d1\n	addl	d1,^",s,d
#define ADDSP(c)	ADDAW(c,Sp)
#define ADDSP2(c,d)	.asm "	movl	^,^\n	movl	^,d1\n	asll	#2,d1\n	addl	d1,^",Sp,d,c,d
#define TABADDR(s,c,d)	.asm "	movl	#^,^\n	movl	^,d1\n	asll	#3,d1\n	addl	d1,^",s,d,c,d
#define MOVIB(s,d)	.asm "	movb	^@,^\n	andl	#255,^",s,d,d
#define MASKB(s,d)	.asm "	movb	^,^\n	andl	#255,^",s,d,d
#define INCBP(p)	.asm "	addql	#1,^",p
#define TSTBIND(r)	.asm "	tstb	^@",r
#define MCOUNTCALL	.asm "	movl	a6,savea6\n	lea	4(a7),a6\n	jmp	mcount"
#define MCOUNTPOST	.asm "	movl	savea6,a6\n	ret\n	.data\nsavea6:	.long	0\n	.text"
#define SETBIT(m,a)	.asm "	movl	^,d7\n	lea	^,a4\n	asrl	#3,d7\n	addl	d7,a4\n	movl	^,d7\n	andl	#7,d7\n	bset	d7,a4@",m,a,m
#define JBITSET(m,a,l)	.asm "	movl	^,d7\n	lea	^,a4\n	asrl	#3,d7\n	addl	d7,a4\n	movl	^,d7\n	andl	#7,d7\n	btst	d7,a4@\n	jne	^",m,a,m,l
#define	BITSUB(a,b,c)	.asm "	movl	^,d7\n	notl	d7\n	andl	^,d7\n	movl	d7,^",a,b,c
#define BITUNI(a,b,c)	.asm "	movl	^,d7\n	orl	^,d7\n	movl	d7,^",b,a,c
#define BITINT(a,b,c)	.asm "	movl	^,d7\n	andl	^,d7\n	movl	d7,^",b,a,c
#define FADD3(a,b,c)	.asm "	fmoved	^,fp0\n	faddd	^,fp0\n	fmoved	fp0,^",a,b,c
#define FSUB3(a,b,c)	.asm "	fmoved	^,fp0\n	fsubd	^,fp0\n	fmoved	fp0,^",a,b,c
#define FMUL3(a,b,c)	.asm "	fmoved	^,fp0\n	fmuld	^,fp0\n	fmoved	fp0,^",a,b,c
#define FDIV3(a,b,c)	.asm "	fmoved	^,fp0\n	fdivd	^,fp0\n	fmoved	fp0,^",a,b,c
#define	FCOMP(a,b)	.asm "	fmoved	^,fp0\n	fcmpd	^,fp0",a,b
#define FJGT(l)		.asm "	fjgt	^",l
#define FJLT(l)		.asm "	fjlt	^",l
#define FITOF(a,b)	.asm "	fmovel	^,fp0\n	fmoved	fp0,^",a,b
#define FFTOI(a,b)	.asm "	fintrzd	^,fp0\n	fmovel	fp0,^",a,b
#define CPUSHFARG(a)	.asm "	fmoved	^,fp0\n	fmoved	fp0,sp@-",a
#endif

#ifdef m_360
	.asm "oeval=0"
	.asm "ounwind=4"
	.asm "ojfun=8"
	.asm "omkapl=12"
	.asm "ogettag=16"
	.asm "ogc=20"
	.asm "ocmp=24"
	.asm "oprint=28"
	.asm "ospark=32"

	.export	callit
callit:
.asm "	using	callit,14"
.asm "	s	10,=8"			; make room
.asm "	st	14,0(10)"		; save ret addr
.asm "	st	11,4(10)"		; save base
.asm "	br	15"
.asm "	ltorg"

#define ARGCREG	r2
#define TAGREG r2
#define BIGEQREG r2
#define INDREG r3

#define GCSTART _startheap
#define GCEND _endheap
#define GCCUR _curheap
#define CRETR r0
#define DTMP r4
#define CDTMP DTMP
#define ATMP r2
#define FDISP r15

#define LBASE		.asm "	using	*,11\n	lr	11,15"
#define CCALL(m,a) 	.asm "	s	10,=72\n	l	15,=a\n	balr	14,15\n	la	10,4*^+72(10)",m
#define CENTRY(m)	.asm "	stm	14,11,12(13)\n	st	13,4(r10)\n	lr	13,10\n	lr	11,15\n	using	*,11\n	la	7,4"
#define CRET		.asm "	l	13,4(0,13)\n	lm	14,11,12(13)\n	br	14"
#define CARG(m,a)	.asm "	l	^,4*^+72(13)",m,a
#define CPUSHARG(a)	.asm "	st	^,72(10)",a
#define DECR(a)		.asm "	bctr	^,0",a
#define TSTC(a)		.asm "	ltr	^,^",a,a
#define ADDAW(s,t)	.asm "	lr	0,^\n	ar	0,0\n	ar	0,0\n	ar	^,0"	,s,t
#define ADDSP(c)	ADDAW(c,Sp)
#define ADDSP2(c,x)	.asm "	lr	^,^\n	ar	^,^\n	ar	^,^\n	ar	^,^"	,x,c,x,x,x,x,x,Sp
#define TABADDR(s,c,d)	.asm "	lr	^,^\n	sll	^,3\n	a	^,=^"	,d,c,d,d,s
#define MOVIB(s,d)	.asm "	ic	^,0(^)\n	n	^,=255",d,s,d
#define MASKB(s,d)	.asm "	lr	^,^\n	n	^,=255",d,s,d
#define INCBP(p)	.asm "	la	^,1(^)",p,p
#define TSTBIND(r)	.asm "	cli	0(^),0",r
#define MCOUNTCALL	.asm "	???"
#define SETBIT(m,a)	.asm "	???"
#define JBITSET(m,a,l)	.asm "	???"
#define	BITSUB(a,b,c)	.asm "	???"
#define BITUNI(a,b,c)	.asm "	???"
#define BITINT(a,b,c)	.asm "	???"
#define FADD3(a,b,c)	.asm "	???"
#define FSUB3(a,b,c)	.asm "	???"
#define FMUL3(a,b,c)	.asm "	???"
#define FDIV3(a,b,c)	.asm "	???"
#define	FCOMP(a,b)	.asm "	???"
#define FJGT(l)		.asm "	???"
#define FJLT(l)		.asm "	???"
#define FITOF(a,b)	.asm "	???"
#define FFTOI(a,b)	.asm "	???"
#define CPUSHFARG(a)	.asm "	???"
#endif

#ifdef m_80386
	.asm	"	.set	oeval,	0"
	.asm	"	.set	ounwind,4"
	.asm	"	.set	ojfun,	8"
	.asm	"	.set	omkapl,	12"
	.asm	"	.set	ogettag,16"
	.asm	"	.set	ogc,	20"
	.asm	"	.set	ocmp,	24"
	.asm	"	.set	oprint,	28"
	.asm	"	.set	ospark,	32"

#ifdef sun386
#define NOUNDERSCORE
#endif

#define ARGCREG	r2
#define TAGREG r2
#define BIGEQREG r2
#define INDREG r4

#define GCSTART _startheap
#define GCEND _endheap
#define GCCUR _curheap
#define CRETR r1
#define DTMP r2
#define CDTMP dtmp
#define realATMP r3
#define ATMP realATMP
#define FDISP r3

#define LBASE		; nothing
#define CCALL(m,a) 	.asm "	call	^\n	addl	$^^,%esp",a,@m
#define CENTRY(m)	.asm "	pushl	%ebp\n	movl	%esp,%ebp\n	subl	$16,%esp\n	pushl	%edi\n	pushl	%esi\n	pushl	%ebx\n	pushl	%ebp\n"
#define CRET		.asm "	popl	%ebp\n	popl	%ebx\n	popl	%esi\n	popl	%edi\n	leave\n	ret"
#define CARG(m,a)	.asm "	movl	^^^(%ebp),^",@m,a
#define CPUSHARG(a)	.asm "	pushl	^",a
#define DECR(a)		.asm "	decl	^",a
#define TSTC(a)		; CC already set
#define ADDAW(s,t)	.asm "	leal	(^,^,4),^",t,s,t
#define ADDSP(c)	.asm "	leal	(^,^,4),^",Sp,c,Sp
#define ADDSP2(c,x)	.asm "	leal	(^,^,4),^",Sp,c,x
#define TABADDR(s,c,d)	.asm "	leal	^(,^,8),^",s,c,d
#define MOVIB(s,d)	.asm "	movzbl	(^),^",s,d
#define MASKB(s,d)	.asm "	movzbl	^,^",s,d
#define INCBP(p)	.asm "	incl	^",p
#define TSTBIND(r)	.asm "	cmpb	$0,(^)",r
#define MCOUNTCALL	.asm "	movl	%ebp,saveebp\n	leal	4(%esp),%ebp\n	movl	%ebx,%eax\n	leal	mcount,%ebx\n	jmp	*%ebx"
#define MCOUNTPOST	.asm "	movl	saveebp,%ebp\n	ret\n	.data\nsaveebp:	.long	0\n	.text"
#define SETBIT(m,a)	.asm "	pushl	^\n	movl	^,^\n	btsl	^,^\n	popl	^",ATMP,m,ATMP,ATMP,a,ATMP
#define JBITSET(m,a,l)	.asm "	pushl	^\n	movl	^,^\n	btl	^,^\n	popl	^\n	jc	^",ATMP,m,ATMP,ATMP,a,ATMP,l
#define	BITSUB(a,b,c)	.asm "	pushl	^\n	movl	^,^\n	notl	^\n	andl	^,^\n	movl	^,^\n	popl	^",ATMP,a,ATMP,ATMP,b,ATMP,ATMP,c,ATMP
#define BITUNI(a,b,c)	.asm "	pushl	^\n	movl	^,^\n	orl	^,^\n	movl	^,^\n	popl	^",ATMP,a,ATMP,b,ATMP,ATMP,c,ATMP
#define BITINT(a,b,c)	.asm "	pushl	^\n	movl	^,^\n	andl	^,^\n	movl	^,^\n	popl	^",ATMP,b,ATMP,a,ATMP,ATMP,c,ATMP
#define FADD3(a,b,c)	.asm "	fldl	^\n	faddl	^\n	fstpl	^",a,b,c
#define FSUB3(a,b,c)	.asm "	fldl	^\n	fsubl	^\n	fstpl	^",a,b,c
#define FMUL3(a,b,c)	.asm "	fldl	^\n	fmull	^\n	fstpl	^",a,b,c
#define FDIV3(a,b,c)	.asm "	fldl	^\n	fdivl	^\n	fstpl	^",a,b,c
#define	FCOMP(a,b)	.asm "	fldl	^\n	fcompl	^\n	fstsw	%ax\n	sahf",a,b
#define FJGT(l)		.asm "	ja	^",l
#define FJLT(l)		.asm "	jb	^",l
#define FITOF(a,b)	.asm "	fildl	^\n	fstpl	^",a,b
#define FFTOI(a,b)	.asm "	fldl	^\n	fistpl	^",a,b
#define CPUSHFARG(a)	.asm "	fldl	^\n	subl	$8,%esp\n	fstpl	0(%esp)",a

#endif

#ifdef m_rtpc
	.asm	"	.set	oeval,	0"
	.asm	"	.set	ounwind,4"
	.asm	"	.set	ojfun,	8"
	.asm	"	.set	omkapl,	12"
	.asm	"	.set	ogettag,16"
	.asm	"	.set	ogc,	20"
	.asm	"	.set	ocmp,	24"
	.asm	"	.set	oprint,	28"
	.asm	"	.set	ospark,	32"

#define ARGCREG	r2
#define TAGREG r2
#define BIGEQREG r2
#define INDREG r3

#define GCSTART _startheap
#define GCEND _endheap
#define GCCUR _curheap
#define CRETR r12
#define DTMP r4
#define CDTMP DTMP
#define realATMP r2
#define ATMP realATMP
#define FDISP r12

#define LBASE		; nothing
#define CCALL(m,a) 	.asm " .globl ^\n .globl ~\n stm r6,-76(r1)\n cal r1,-76(r1)\n get  r0,$^\n bali r15,~\n cal r1,76(r1)\n lm r6,-76(r1)\n",a,a,a,a
#define CENTRY(m)	.asm " stm r6,-76(r1)\n cal r1,-76(r1)\n"
#define CRET		.asm " cal r1,76(r1)\n lm r6,-76(r1)\n br r15\n"
#define CARG(m,a)	.asm " cas ^,!,r0\n",a,m
#define CPUSHARG0(a)	move a, r12
#define CPUSHARG1(a)	move a, r13
#define CPUSHARG2(a)	move a, r14
#define DECR(a)		.asm " sis ^,1",a
#define TSTC(a)		; CC already set
#define ADDAW(s,d)	.asm " ai ^,^\n ai ^,^\n ai ^,^\n ai ^,^\n",d,s,d,s,d,s,d,s
#define ADDSP(c)	.asm " ai ^,^\n ai ^,^\n ai ^,^\n ai ^,^\n",Sp,c,Sp,c,Sp,c,Sp,c
#define ADDSP2(c,x)	.asm " mr ^,^\n sli ^,2\n ai ^,^\n",x,c,x,x,Sp
#define TABADDR(s,c,d)	.asm " mr ^,^\n sli ^,3\n get r4,$^\n a ^,r4\n",d,c,d,s,d
#define MOVIB(s,d)	.asm " lcs ^,0(^)\n",d,s
#define MASKB(s,d)	.asm " nilz ^,^,255\n",d,s
#define INCBP(p)	.asm " inc ^,1\n",p
#define TSTBIND(r)	.asm " lcs r4,0(^)\n cis r4,0\n",r
#define MCOUNTCALL	.asm "# no profiling done"
#define SETBIT(m,a)	.asm "#	???\nSETBIT: j SETBIT\n"
#define JBITSET(m,a,l)	.asm "#	???\nJBITSET: j JBITSET\n"
#define	BITSUB(a,b,c)	.asm "#	???\nBITSUB: j BITSUB\n"
#define BITUNI(a,b,c)	.asm "#	???\nBITUNI: j BITUNI\n"
#define BITINT(a,b,c)	.asm "#	???\nBITINT: j BITINT\n"
#define FADD3(a,b,c)	.asm "# ???\nFADD3: j FADD3\n"
#define FSUB3(a,b,c)	.asm "# ???\nFSUB3: j FSUB3\n"
#define FMUL3(a,b,c)	.asm "# ???\nFMUL3: j FMUL3\n"
#define FDIV3(a,b,c)	.asm "# ???\nFDIV3: j FDIV3\n"
#define	FCOMP(a,b)	.asm "# ???\nFCOMP: j FCOMP\n"
#define FJGT(l)		.asm "# ???\nFJGT: j FJGT\n"
#define FJLT(l)		.asm "# ???\nFJLT: j FJLT\n"
#define FITOF(a,b)	.asm "# ???\nFITOF: j FITOF\n"
#define FFTOI(a,b)	.asm "# ???\nFFTOI: j FFTOI\n"
#define CPUSHFARG(a)	.asm "# ???\nCPUSHFARG: j CPUSHFARG\n"

#endif

#ifdef m_cray

#define SDATAT .data

#define NOCOMPARE
#define NOUNDERSCORE

;These must be the same as in machine
#define ARGCREG r11
#define TAGREG r11
#define BIGEQREG r11
#define INDREG r3

; Should place these in B-registers
#define GCSTART _startheap
#define GCEND   _endheap
#define GCCUR   _curheap

#define CRETR r9
#define DTMP r12
#define CDTMP DTMP

; ATMP /= FDISP /= INDREG
#define realATMP r2
#define ATMP realATMP
#define FDISP r2

	.asm	"|EXT|STOFERR"
	.asm	"|EXT|STOFJMP"
	.asm	"|EXT|$STKOFEN:p"

#define LBASE		; nothing
#define CCALL(m,a) 	.asm "* CCALL\n|A0|B00\n|B10|A0\n|B11|A1\n|B12|A2\n|B13|A3\n|B14|A4\n|B15|A5\n|B16|A6\n|B17|A7\n|T02|S2\n|T03|S3\n|T04|S4\n|T05|S5\n|T06|S6\n|T07|S7\n|S2|9\n|A6|&\n|S2|S2<24\n|S3|^\n|A6|A7-A6\n|S3|S2!S3\n|0,A6|S3\n|R|P.~\n|A0|B10\n|B00|A0\n|A1|B11\n|A2|B12\n|A3|B13\n|A4|B14\n|A5|B15\n|A6|B16\n|A7|B17\n|S2|T02\n|S3|T03\n|S4|T04\n|S5|T05\n|S6|T06\n|S7|T07\n",m,m,a

#define CPUSHARG(a)	.asm "* CPUSHARG\n|S0|^\n|-1,A7|S0\n",a

#define CENTRY(m) .asm "* CENTRY\n|A0|B66\n|A5|17\n|A2|B66\n|0,A0|B77,A5\n|A0|A2+A5\n|A5|16\n|B02|A2\n|B01|A6\n|0,A0|T70,A5\n|A5|5033\n|A5|A5+A2\n|A2|B67\n|A0|A2-A5\n|B66|A5\n|A2|B02\n|JAM|#2\n%1\n|A3|B02\n|A0|A3-A2\n|JAN|STOFJMP\n|A3|24\n|A2|A2+A3\n|B03|A2\n|A7|B66\n|J|#3\n%2\n|A6|STKDUMMY\n|R|P.$STKOFEN\n|J|#1\n%3\n"

#define CRET		.asm "* CRET\n|A0|B02\n|A1|17\n|A2|B02\n|B77,A1|0,A0\n|A0|A2+A1\n|A1|16\n|T70,A1|0,A0\n|B66|A2\n|J|B00\n"

#define CARG(m,a)	.asm "* CARG\n|^|B01\n|^|^+1,^\n",a,a,m,a

#define DECR(r)		.asm "* DECR\n|S1|1\n|^|^-S1\n",r,r
#define TSTC(a)		comp a,$0
#define ADDAW(ir,r)	.asm "* ADDAW\n|B11|A1\n|A1|^\n|^|^+A1\n|A1|B11\n",ir,r,r
#define ADDSP(c)	.asm "* ADDSP\n|B11|A1\n|A1|^\n|A6|A6+A1\n|A1|B11\n",c
#define ADDSP2(ir,r)	.asm "* ADDSP2\n|^|^\n|^|^+A6\n",r,ir,r,r
#define TABADDR(l,r1,r2) .asm "* TABADDR\n|B11|A1\n|A1|~\n|^|^\n|^|^+^\n|^|^+A1\n|A1|B11\n",l,r2,r1,r2,r2,r2,r2,r2

#define MOVIB(r1,r2)	.asm "* MOVIB\n|^|0,^\n",r2,r1
#define MASKB(r1,r2)	.asm "* MASKB\n|^|255\n|^|^\&^\n",r2,r2,r1,r2
#define INCBP(r)	.asm "* INCBP\n|^|^+1",r,r
#define TSTBIND(r)	.asm "* TSTBIND\n|S1|0,^\n|S2|255\n|S0|S2\&S1\n",r

#define MCOUNTCALL	.asm "* no profiling done"
#define SETBIT(m,a)	.asm "* ??? SETBIT: j SETBIT\n"
#define JBITSET(m,a,l)	.asm "* ??? JBITSET: j JBITSET\n"
#define	BITSUB(a,b,c)	.asm "* ??? BITSUB: j BITSUB\n"
#define BITUNI(a,b,c)	.asm "* ??? BITUNI: j BITUNI\n"
#define BITINT(a,b,c)	.asm "* ??? BITINT: j BITINT\n"
#define FADD3(a,b,c)	.asm "* ??? FADD3: j FADD3\n"
#define FSUB3(a,b,c)	.asm "* ??? FSUB3: j FSUB3\n"
#define FMUL3(a,b,c)	.asm "* ??? FMUL3: j FMUL3\n"
#define FDIV3(a,b,c)	.asm "* ??? FDIV3: j FDIV3\n"
#define	FCOMP(a,b)	.asm "* ??? FCOMP: j FCOMP\n"
#define FJGT(l)		.asm "* ??? FJGT: j FJGT\n"
#define FJLT(l)		.asm "* ??? FJLT: j FJLT\n"
#define FITOF(a,b)	.asm "* ??? FITOF: j FITOF\n"
#define FFTOI(a,b)	.asm "* ??? FFTOI: j FFTOI\n"
#define CPUSHFARG(a)	.asm "* ??? CPUSHFARG: j CPUSHFARG\n"

#endif

#ifdef m_mips

#define NOCOMPARE
#define NOUNDERSCORE
#define SDATAT .asm	".sdata"
#define SDATAD .asm	".sdata"

#define ARGCREG	r2
#define TAGREG r2
#define BIGEQREG r2
#define INDREG r31

#define GCSTART r13
#define GCEND r12
#define GCCUR r11
#define CRETR r26
#define DTMP r5
#define CDTMP DTMP
#define ATMP r3
#define FDISP r4
#define rd r29
#define ehpr r22

#define LBASE		; nothing
#define CCALL(m,a) 	.asm "	move	$16,$sp\n	subu	$sp,72\n	and	$sp,$sp,-8\n	sw	$31,60($sp)\n	jal	^\n	lw	$31,60($sp)\n	move	$sp,$16\n	lw	^,ehp",a,ehpr
#define CENTRY(m)	.asm "	subu	$sp,256\n	sd	$16,20($sp)\n	sd	$18,28($sp)\n	sd	$20,36($sp)\n	sd	$22,44($sp)\n	sd	$4,52($sp)\n	sd	$6,60($sp)	\nsw	$31,16($sp)\n	lw	^,ehp",ehpr
#define CRET		.asm "	ld	$16,20($sp)\n	ld	$18,28($sp)\n	ld	$20,36($sp)\n	ld	$22,44($sp)\n	ld	$4,52($sp)\n	ld	$6,60($sp)	\nlw	$31,16($sp)\n	addu	$sp,256\n	j	$31"
#define CARG0(a)	move	r28,a
#define CARG1(a)	move	r29,a
#define CPUSHARG0(a)	move	a,r28
#define CPUSHARG1(a)	move	a,r29
#define CPUSHARG2(a)	move	a,r30
#define DECR(a)		.asm "	subu	^,1",a
#define TSTC(a)		comp	a,$0
#define ADDAW(s,d)	move	s,rd && .asm "	sll	^,^,2",rd,rd && add2 rd,d
#define ADDSP(c)	ADDAW(c,Sp)
#define ADDSP2(c,d)	move	c,rd && .asm "	sll	^,^,2",rd,rd && add Sp,rd,d
#define TABADDR(s,c,d)	move	c,d && .asm "	sll	^,3\n	la	^,^",d,rd,s && add2 rd,d
#define MOVIB(s,d)	.asm "	lb	^,0(^)\n	and	^,255",d,s,d
#define MASKB(s,d)	.asm "	move	^,^\n	and	^,255",d,s,d
#define INCBP(p)	.asm "	addu	^,1",p
#define TSTBIND(r)	.asm "	lb	^,0(^)",rd,r && comp rd,$0
#define MCOUNTCALL	.asm "	#???MCOUNTCALL"
#define MCOUNTPOST	.asm "	#???MCOUNTPOST"
#define SETBIT(m,a)	.asm "	#???SETBIT"
#define JBITSET(m,a,l)	.asm "	#???JBITSET"
#define	BITSUB(a,b,c)	.asm "	#???BITSUB"
#define BITUNI(a,b,c)	.asm "	#???BITUNI"
#define BITINT(a,b,c)	.asm "	#???BITINT"
#define FADD3(a,b,c)	.asm "	l.d	$f4,^\n	l.d	$f6,^\n	add.d	$f8,$f4,$f6\n	s.d	$f8,^",a,b,c
#define FSUB3(a,b,c)	.asm "	l.d	$f4,^\n	l.d	$f6,^\n	sub.d	$f8,$f4,$f6\n	s.d	$f8,^",a,b,c
#define FMUL3(a,b,c)	.asm "	l.d	$f4,^\n	l.d	$f6,^\n	mul.d	$f8,$f4,$f6\n	s.d	$f8,^",a,b,c
#define FDIV3(a,b,c)	.asm "	l.d	$f4,^\n	l.d	$f6,^\n	div.d	$f8,$f4,$f6\n	s.d	$f8,^",a,b,c
#define FCGOTO(a,b,gtl,ltl)	.asm	"	l.d	$f2,^\n	l.d	$f4,^\n	c.lt.d	$f4,$f2\n	bc1t	^\n	c.lt.d	$f2,$f4\n	bc1t	^",a,b,gtl,ltl
#define FITOF(a,b)	.asm "	lw	$2,^\n	mtc1	$2,$f8\n	cvt.d.w	$f10,$f8\n	s.d	$f10,^",a,b
#define FFTOI(a,b)	.asm "	l.d	$f4,^\n	trunc.w.d	$f2,$f4,$3\n	mfc1	$2,$f2\n	sw	$2,^",a,b
#define CPUSHFARG(a)	.asm "	???CPUSHFARG"
#endif

#ifdef m_sparc

#define ARGCREG	r2
#define TAGREG r2
#define BIGEQREG r2
#define INDREG r8

#define GCSTART r9
#define GCEND r10
#define GCCUR r11
#define CRETR r16
#define DTMP r12
#define CDTMP DTMP
#define ATMP r3
#define FDISP r4
#define rd r25
#define ehpr r13
#define vpr r5
#define retr r23

#define LBASE		; nothing
#define CCALL(m,a) 	move	retr,Vpush && move Vp,_vp && .asm "	call	^,^\n	nop",a,m && move _vp,Vp && move _ehp,ehpr && move Vpop,retr
#define CENTRY(m)	.asm "	save	%sp,-96,%sp" && move _vp,Vp && move _ehp,ehpr
#define CRET		move Vp,_vp && .asm "	ret	\n	restore"
#define CARG0(a)	move	r8,a
#define CARG1(a)	move	r9,a
#define CPUSHARG0(a)	move	a,r16
#define CPUSHARG1(a)	move	a,r17
#define CPUSHARG2(a)	move	a,r18
#define DECR(a)		.asm "	dec	^",a
#define TSTC(a)		comp	a,$0
#define ADDAW(s,d)	move	s,rd && .asm "	sll	^,2,^",rd,rd && add2 rd,d
#define ADDSP(c)	ADDAW(c,Sp)
#define ADDSP2(c,d)	move	c,rd && .asm "	sll	^,2,^",rd,rd && add Sp,rd,d
#define TABADDR(s,c,d)	move	c,d && .asm "	sll	^,3,^\n	set	^,^",d,d,s,rd && add2 rd,d
#define MOVIB(s,d)	.asm "	ldub	[^],^",s,d
#define MASKB(s,d)	.asm "	mov	^,^\n	and	^,255,^",s,d,d,d
#define INCBP(p)	.asm "	inc	^",p
#define TSTBIND(r)	.asm "	ldub	[^],^",r,rd && comp rd,$0
#define MCOUNTCALL	.asm "	!???MCOUNTCALL"
#define MCOUNTPOST	.asm "	!???MCOUNTPOST"
#define SETBIT(m,a)	.asm "	!???SETBIT"
#define JBITSET(m,a,l)	.asm "	!???JBITSET"
#define	BITSUB(a,b,c)	.asm "	!???BITSUB"
#define BITUNI(a,b,c)	.asm "	!???BITUNI"
#define BITINT(a,b,c)	.asm "	!???BITINT"
#define FADD3(a,b,c)	.asm "	ld	^,%f0\n	ld	~,%f1\n	ld	^,%f2\n	ld	~,%f3\n	faddd	%f0,%f2,%f4\n	st	%f4,^\n	st	%f5,~",a,a,b,b,c,c
#define FSUB3(a,b,c)	.asm "	ld	^,%f0\n	ld	~,%f1\n	ld	^,%f2\n	ld	~,%f3\n	fsubd	%f0,%f2,%f4\n	st	%f4,^\n	st	%f5,~",a,a,b,b,c,c
#define FMUL3(a,b,c)	.asm "	ld	^,%f0\n	ld	~,%f1\n	ld	^,%f2\n	ld	~,%f3\n	fmuld	%f0,%f2,%f4\n	st	%f4,^\n	st	%f5,~",a,a,b,b,c,c
#define FDIV3(a,b,c)	.asm "	ld	^,%f0\n	ld	~,%f1\n	ld	^,%f2\n	ld	~,%f3\n	fdivd	%f0,%f2,%f4\n	st	%f4,^\n	st	%f5,~",a,a,b,b,c,c
#define	FCOMP(a,b)	.asm "	ld	^,%f0\n	ld	~,%f1\n	ld	^,%f2\n	ld	~,%f3\n	fcmped	%f0,%f2\n	nop",a,a,b,b
#define FJGT(l)		.asm "	fbug	^\n	nop",l
#define FJLT(l)		.asm "	fbul	^\n	nop",l
#define FITOF(a,b)	.asm "	ld	^,%f0\n	fitod	%f0,%f2\n	st	%f2,^\n	st	%f3,~",a,b,b
#define FFTOI(a,b)	.asm "	ld	^,%f0\n	ld	~,%f1\n	fdtoi	%f0,%f2\n	st	%f2,^",a,a,b
/*#define CPUSHFARG(a)	.asm "	!???CPUSHFARG"*/
#endif

#ifdef CARG
#define CARG0(a)	CARG(0,a)
#define CARG1(a)	CARG(1,a)
#endif

#ifdef CPUSHARG
#define CPUSHARG0(x)	CPUSHARG(x)
#define CPUSHARG1(x)	CPUSHARG(x)
#define CPUSHARG2(x)	CPUSHARG(x)
#endif

#ifndef SDATAD
#define SDATAD	.data
#endif
#ifndef SDATAT
#define SDATAT	.text
#endif
