/*********************************************************************/
/*
**	Stuff for constructing constructor nodes from C prgrams.
**	The intended use is in yacc actions, to build abstract syntax trees.
*/
#define N 5

extern int 	*INT[], *CHAR[], *TAG[], *TAG0[],
		*PAIR0[], *PAIR1[], *PAIR2[], *PAIR3[], *PAIR4[],
		*STRING[], *VEK[],
		*MARKED[], *MOVED[], *AP[], *FUN[], *VAP[],
		*HOLE[], *INPUT[], *GCRET[];

int **
MKpair(no, a1, a2)
int no, *a1, *a2;
{
    switch(no){
    case 0: *hp++ = (int *)PAIR0; break;
    case 1: *hp++ = (int *)PAIR1; break;
    case 2: *hp++ = (int *)PAIR2; break;
    case 3: *hp++ = (int *)PAIR3; break;
    case 4: *hp++ = (int *)PAIR4; break;
    default: fprintf(stderr, "MKpair: > 4.\n"); finish(1);
    }
    *hp++ = a1;
    *hp++ = a2;
    return hp-3;
}

int **
MKtag(no, a)
int no, *a;
{
    *hp++ = (int *)TAG;
    *hp++ = (int *)no;
    *hp++ = a;
    return hp-3;
}

int **
MKvek(argc, A)
int argc, *A[];
{
    register int i;
    if(argc == 1){
	return (int **)A[0];
    } else if(argc == 2){
	*hp++ = (int *)PAIR0;
	*hp++ = A[0];
	*hp++ = A[1];
	return hp-3;
    } else {
	*hp++ = (int *)VEK;
	*hp++ = (int *)argc;
	for(i = 0;i < argc; argc++)
	    *hp++ = A[i];
	return hp-2-argc;
    }
}

/*VARARGS2*/
int **
MK(no, argc, a)
int no, argc, **a;
{
    int ***A = &a;
    int **r;
    if(argc == 0){
	*hp++ = (int *)TAG0;
	*hp++ = (int *)no;
	r = hp-2;
    } else if(argc == 1) {
	r = MKtag(no, A[0]);
    } else if(no < N) {
	r = MKpair(no, MKvek(argc-1, A), A[argc-1]);
    } else {
	r = MKtag(no, MKvek(argc, A));
    }
    return r;
}

int **
MKint(i)
int i;
{
    *hp++ = (int *)INT;
    *hp++ = (int *)i;
    return hp-2;
}

int **
MKchar(c)
int c;
{
    *hp++ = (int *)CHAR;
    *hp++ = (int *)c;
    return hp-2;
}

int **
MKstring(s)
char *s;
{
    if(*s)
	return MKpair(1, MKchar(*s), MKstring(s+1));
    else
	return MK(0,0); /* Nil */
}

int **
MKap(a1,a2)
int *a1, *a2;
{
    *hp++ = (int *)AP;
    *hp++ = a1;
    *hp++ = a2;
    return hp-3;
}

int **
MKfapl(n, f, a1)
int **f, n, **a1;
{
    int ***A = &a1;
    int **r = f;
    for(;n ; n--)
	r = MKap(r, *A++);
    return r;
}

MKupd(p)
int **p;
{
    extern int *parse_tree[];

    parse_tree[0] = p[0];
    parse_tree[1] = p[1];
    parse_tree[2] = p[2];
}
#undef N
