%{
#include <stdio.h>
#include "include.h"
#include "listgen.h"
extern tree root;
extern impstuff iroot;

int curryflag = 0;

#define UFRS (-2)
extern id installid();
extern tree niltree;
extern list Lnil;
#define lsing(l) mklcons(l, Lnil)
#define ldub(l1, l2) mklcons(l1, lsing(l2))
extern int Eflag;

extern list lconc(), lapp();
extern tree mkbool(), mkbinop(), mkunop(), mkcons(), mkif(), mkand(), mkor(),
	    mknot(), mkfcomp(), mksection(), mkterop();
extern char *tupstr();
extern void pimpid();
extern char loadname[];
finfot finfofromstring();
char *leftmostid();

tree checkpat();

%}

%union {
	tree utree;
	list ulist;
	ttype uttype;
	atype uatype;
	binding ubinding;
	pbinding upbinding;
	finfot ufinfo;
	impidt uimpid;
	id uid;
	int uint;
	char *ustring;
	qual uqual;
	double ufloat;
	impstuff uimpstuff;
}

%token		ID NONFIX INTCONST CHAR STRING FLOATCONST INTEGERCONST
		LAMBDA DOT LET LETREC IN WHERE WHEREREC LPAR RPAR 
		LBRACK RBRACK LBRACE RBRACE GUARD REC TYPE
		EQ NE LT GT LE GE
		IF THEN ELSE COMMA AND
		PLUS MINUS TIMES DIV MOD NOT ANDOP OROP COLON CONC INDEX
                FPLUS FMINUS FTIMES FDIV
    		IPLUS IMINUS ITIMES IDIV IMOD
    		LINDEX RAISE
		SEMI FCOMP EXCL
		MODULE END IMPORT EXPORT
		TFUN TPAIR
		CASE WILD AS LOCAL
%token		SUCH RARROW DOTDOT
%token		ANNOT
%token		MINFIX MINFIXR MPREFIX MNONFIX MPOSTFIX
%token		SYNTAX_ERROR
%token		LOAD MLOAD OLOAD LEOF SOURCE THEEND
%right		TFUN
%right		TPAIR
%nonassoc	EXCL
%nonassoc	LET LETREC IN REC TYPE
%nonassoc	WHERE WHEREREC
%right		AND
%nonassoc	LAMBDA 
%nonassoc	IF THEN ELSE
%nonassoc	AS
%right		COLON
%right		COMMA
%right		CONC
%right		DOT
%right		OROP
%right		ANDOP
%nonassoc	NOT
%right		EQ NE LT GT LE GE
%left 		PLUS MINUS FPLUS FMINUS IPLUS IMINUS
%left		TIMES DIV MOD FTIMES FDIV ITIMES IDIV IMOD
%right		RAISE
%left		INDEX LINDEX
%nonassoc	UMINUS
%left		FCOMP
%left		INFIXL
%right		INFIXR
%nonassoc	PREFIX POSTFIX
%nonassoc	ID NONFIX INTCONST NIL CHAR STRING WILD FLOATCONST INTEGERCONST
%right		LBRACK
%left		PREC_AP LPAR LBRACE CASE LOCAL
%left		P_ANNOT

%type <uimpstuff> typinfo
%type <utree> aexpr expr items cpexpr apexpr pexpr pitems module epat
%type <ulist> imports exports impids constrs expids cases typevars funs types stypes tpairs qual
%type <uqual> qual1
%type <uimpid> impid
%type <ubinding> binding
%type <ustring> STRING INTEGERCONST
%type <ufloat> FLOATCONST
%type <uid> iid ID NONFIX ident INFIXL INFIXR PREFIX POSTFIX fixid id binop WILD tid ttid binop1 op annot ANNOT TFUN
%type <uint> INTCONST CHAR
%type <uttype> type typename typevar atype stype
%type <ufinfo> finfo
%type <upbinding> casee fun
%type <uatype> constr
%type <uid> EQ NE LT GT LE GE TIMES DIV MOD PLUS MINUS FTIMES FDIV FPLUS FMINUS ITIMES IDIV IMOD IPLUS IMINUS INDEX LINDEX RAISE DOT CONC FCOMP COMMA NOT OROP ANDOP

%%
top     : 'i' commands end | unit | 'p' interf;

/** Interactive **/

end	: THEEND { seteof(); }

commands: commands command
          |
          /* empty */
          ;

command	: expr SEMI                     { picmd(mkIexpr($1)); }
          |
          LET binding SEMI              { picmd(mkIbinding($2)); }
          |
	  LOAD STRING SEMI { switchto($2); } load
          |
	  SOURCE STRING SEMI		{ source($2); }
	  |
	  LEOF				{ picmd(mkInull()); }
	  |
	  infix                         { picmd(mkInull()); }
	  |
          SEMI				{ picmd(mkInull()); }
          |
          error SEMI			{ picmd(mkInull()); }
/*	  error { while(yylex() != SEMI); yyerrok; yyclearin; } */
          ;

load	: OLOAD imports LEOF 		{ picmd(mkItload(mkstring(loadname), $2)); }
	  |
	  MLOAD module LEOF 		{ picmd(mkImload($2)); }
	  |
    	  LEOF				{ picmd(mkInull()); }
	  ;


/** Interface **/
interf	: imports		{ iroot = mkinterface("_lml", Lnil, Lnil, $1); /*!!!*/}
	;

/** Compiler **/

unit	: imports expr		{ root = Eflag ? $2 :
				    mkmodule(
					$1,
					lsing("Pmain"),
					    mkpbind(lsing(mkppat(
					       mkident("Pmain"), 
					       mklam(mkident("_input"), $2))
						    )));
					} |
          module		{ root = $1; }
          ;

module	: MODULE imports exports binding END
					{ $$ = mkmodule($2, $3, $4); }
	  ;


infix	: MINFIX STRING SEMI		{ makeinfix($2, INFIXL); }
	  |
	  MINFIXR STRING SEMI		{ makeinfix($2, INFIXR); }
	  |
	  MPREFIX STRING SEMI		{ makeinfix($2, PREFIX); }
	  |
	  MPOSTFIX STRING SEMI		{ makeinfix($2, POSTFIX); }
	  |
	  MNONFIX STRING SEMI		{ makeinfix($2, NONFIX); }
	  ;
  
imports	: imports IMPORT impids SEMI	{ $$ = lconc($1, $3); } |
          imports infix                 { $$ = $1; } |
	  /* empty */			{ $$ = Lnil; }
	  ;

impids	: impid				{ $$ = lsing($1); } |
	  impids COMMA impid	 	{ $$ = lapp($1, $3); }
	  ;

impid	: iid COLON type finfo		{ $$ = mkimpid($1, $3, $4); } |
	  TYPE typename	typinfo		{ $$ = mkimptype($2, mkinone(), $3); } |
	  TYPE typename EQ constrs	{ $$ = mkimpeqtype($2, $4, mkinone()); } |
          TYPE typename EQ EQ type      { $$ = mkimpsyn($2, $5); }
	  ;

typinfo	: /* empty */			{ $$ = mkinone(); } |
	  ANNOT				{ int n; char buf[100]; if (sscanf($1, "%d,%[TF]", &n, buf) != 2) yyerror("Bad type info");
					  $$ = mkitypinfo(n, buf[0] == 'T'); }
	  ;

exports	: EXPORT expids SEMI		{ $$ = $2; } |
	  EXPORT SEMI			{ $$ = Lnil; } |
	  /* empty */			{ $$ = Lnil; }
	  ;

expids	: iid				{ $$ = lsing($1); } |
	  expids COMMA iid 		{ $$ = lapp($1, $3); }
	  ;

iid	: fixid				{ $$ = $1; } |
	  id				{ $$ = $1; } |
          LPAR ident RPAR		{ $$ = $2; }
	  ;

fixid	: INFIXL			{ $$ = $1; } |
	  INFIXR			{ $$ = $1; } |
	  PREFIX			{ $$ = $1; } |
	  POSTFIX			{ $$ = $1; }
	  ;


aexpr	: id				{ $$ = mkident($1); } |
	  INTCONST			{ $$ = mkinteger($1); } |
          FLOATCONST			{ $$ = mkfloatt($1); } |
          INTEGERCONST			{ $$ = mkbignum($1); } |
/*          MINUS FLOATCONST		{ $$ = mkfloatt(-$2); } | causes many conflicts */
	  CHAR				{ $$ = mkcharr($1); } |
	  STRING			{ $$ = mkstring($1); } |
	  LPAR expr RPAR		{ $$ = mkpar($2); } |
	  LBRACK items RBRACK		{ $$ = $2; } |
	  LBRACK RBRACK			{ $$ = niltree; } |
	  LBRACK expr DOTDOT RBRACK	{ $$ = mklistf(L_FROM, lsing($2)); } |
	  LBRACK expr SEMI expr DOTDOT RBRACK	{ $$ = mklistf(L_FROM_BY, ldub($2, $4)); } |
	  LBRACK expr DOTDOT expr RBRACK	{ $$ = mklistf(L_FROM_TO, ldub($2, $4)); } |
	  LBRACK expr SEMI expr DOTDOT expr RBRACK	{ $$ = mklistf(L_FROM_BY_TO, mklcons($2, ldub($4, $6))); } |
	  LBRACK expr SUCH qual RBRACK	{ $$ = mklistg($2, nrev(&$4)); } |
	  LPAR expr binop RPAR		{ $$ = mkap(mkident($3), $2); } |
	  LPAR binop1 expr RPAR		{ $$ = mksection($2, $3); } |
	  CASE expr IN cases END	{ $$ = mkcasee($2, $4); }
	  ;

expr	: aexpr				{ $$ = $1; } |
	  expr COLON type		{ $$ = mkrestr($1, $3); } |
	  LET EXCL cpexpr EQ expr IN expr { $$ = mkcasee($5,lsing(mkppat($3,$7))); } |
	  LET binding IN expr 		{ $$ = mkletv($2,$4); } |
	  expr WHERE binding 		{ $$ = mkletv($3,$1); } |
	  LAMBDA apexpr DOT expr %prec LAMBDA	{ $$ = mklam($2,$4); } |
	  IF expr THEN expr ELSE expr 	{ $$ = mkterop("Pif", $2, $4, $6); } |
	  expr OROP expr 		{ $$ = mkbinop($2, $1,$3); } |
	  expr ANDOP expr 		{ $$ = mkbinop($2, $1,$3); } |
	  NOT expr 			{ $$ = mkunop($1, $2); } |
	  expr EQ expr 			{ $$ = mkbinop($2, $1,$3); } |
	  expr NE expr 			{ $$ = mkbinop($2, $1,$3); } |
	  expr LT expr			{ $$ = mkbinop($2, $1,$3); } |
	  expr GT expr			{ $$ = mkbinop($2, $1,$3); } |
	  expr LE expr			{ $$ = mkbinop($2, $1,$3); } |
	  expr GE expr			{ $$ = mkbinop($2, $1,$3); } |
	  expr TIMES expr		{ $$ = mkbinop($2, $1,$3); } |
	  expr DIV expr			{ $$ = mkbinop($2, $1,$3); } |
	  expr MOD expr			{ $$ = mkbinop($2, $1,$3); } |
	  expr PLUS expr		{ $$ = mkbinop($2, $1,$3); } |
	  expr MINUS expr 		{ $$ = mkbinop($2, $1, $3); } |
	  expr FTIMES expr		{ $$ = mkbinop($2, $1,$3); } |
	  expr FDIV expr		{ $$ = mkbinop($2, $1,$3); } |
	  expr FPLUS expr		{ $$ = mkbinop($2, $1,$3); } |
	  expr FMINUS expr 		{ $$ = mkbinop($2, $1,$3); } |
	  expr ITIMES expr		{ $$ = mkbinop($2, $1,$3); } |
	  expr IDIV expr		{ $$ = mkbinop($2, $1,$3); } |
	  expr IMOD expr		{ $$ = mkbinop($2, $1,$3); } |
	  expr IPLUS expr		{ $$ = mkbinop($2, $1,$3); } |
	  expr IMINUS expr 		{ $$ = mkbinop($2, $1,$3); } |
	  expr INDEX expr 		{ $$ = mkbinop($2, $1, $3); } |
	  expr LINDEX expr 		{ $$ = mkbinop($2, $1, $3); } |
	  expr RAISE expr 		{ $$ = mkbinop($2, $1, $3); } |
	  expr INFIXL expr		{ $$ = mkbinop($2, $1, $3); } |
	  expr INFIXR expr		{ $$ = mkbinop($2, $1, $3); } |
	  MINUS expr %prec UMINUS 	{ $$ = mkunop("_negate", $2); } |
	  expr aexpr %prec PREC_AP	{ $$ = mkap($1,$2); } |
	  expr DOT  expr		{ $$ = mkcons($1, $3); } |
	  expr CONC expr		{ $$ = mkbinop($2, $1,$3); } |
	  expr FCOMP expr		{ $$ = mkfcomp($1, $3); } |
	  PREFIX expr			{ $$ = mkunop($1, $2); } |
	  expr POSTFIX			{ $$ = mkunop($2, $1); } |
	  expr COMMA expr		{ if (ttree($3) == tuple)
						$$ = mktuple(mklcons($1, gtuplelist($3)));
					  else
						$$ = mktuple(ldub($1, $3));
					} |
	  aexpr annot %prec P_ANNOT	{ $$ = mkeannot($1, $2); }
	  ;

qual	: qual SEMI qual1		{ $$ = mklcons($3, $1); } |
	  qual1				{ $$ = lsing($1); }
	  ;

qual1	: epat RARROW expr		{ $$ = mkqgen($1, $3); } |
	  expr				{ $$ = mkqfilter($1); }
	  ;
epat	: expr				{ $$ = checkpat($1); }
	  ;



id	: LPAR op RPAR			{ $$ = $2; } |
	  ident				{ $$ = $1; }
	  ;

op	: binop				{ $$ = $1; } |
	  NOT				{ $$ = $1; } |
	  PREFIX			{ $$ = $1; } |
	  POSTFIX			{ $$ = $1; }
	  ;

binop	: binop1			{ $$ = $1; } |
	  MINUS 			{ $$ = $1; }
	  ;

binop1	: OROP 				{ $$ = $1; } |
	  ANDOP 			{ $$ = $1; } |
	  EQ 				{ $$ = $1; } |
	  NE 				{ $$ = $1; } |
	  LT				{ $$ = $1; } |
	  GT				{ $$ = $1; } |
	  LE				{ $$ = $1; } |
	  GE				{ $$ = $1; } |
	  TIMES				{ $$ = $1; } |
	  DIV				{ $$ = $1; } |
	  MOD				{ $$ = $1; } |
	  PLUS				{ $$ = $1; } |
	  INFIXL			{ $$ = $1; } |
	  INFIXR			{ $$ = $1; } |
	  DOT 				{ $$ = $1; } |
	  CONC				{ $$ = $1; } |
	  FCOMP				{ $$ = $1; } |
	  COMMA				{ $$ = $1; } |
	  INDEX				{ $$ = $1; } |
	  LINDEX			{ $$ = $1; } |
	  RAISE				{ $$ = $1; } |
          FPLUS				{ $$ = $1; } |
          FMINUS			{ $$ = $1; } |
          FTIMES			{ $$ = $1; } |
          FDIV				{ $$ = $1; } |
          IPLUS				{ $$ = $1; } |
          IMINUS			{ $$ = $1; } |
          ITIMES			{ $$ = $1; } |
          IDIV				{ $$ = $1; } |
          IMOD				{ $$ = $1; }
	  ;

items	: expr SEMI items		{ $$ = mkcons($1, $3); } |
	  expr				{ $$ = mkcons($1, niltree); }
	  ;

cases	: casee				{ $$ = lsing($1); } |
	  cases GUARD casee		{ $$ = lapp($1, $3); }
	  ;

casee	: cpexpr COLON expr		{ $$ = mkppat($1, $3); }
	  ;

binding:  funs				{ $$ = mkpbind($1); } |
	  TYPE typename EQ constrs	{ $$ = mktbind($2, $4, mkinone()); adderrinfo(gtypeid($2)); } |
          TYPE typename EQ EQ type      { $$ = mkebind($2, $5); } |
	  binding AND binding		{ $$ = mkabind($1, $3); } |
	  REC binding			{ $$ = mkrbind($2); } |
	  LPAR binding RPAR		{ $$ = $2; } |
	  LOCAL binding IN binding END	{ $$ = mklbind($2, $4); }
	  ;

typename: tid				{ $$ = mktname($1, Lnil); } |
	  tid typevars			{ $$ = mktname($1, $2); } |
	  LPAR typename RPAR		{ $$ = $2; }
	  ;

typevars: typevar typevars		{ $$ = mklcons($1, $2); } |
	  typevar			{ $$ = lsing($1); }
	  ;

funs	: fun 				{ $$ = lsing($1); } |
	  funs GUARD fun		{ $$ = lapp($1, $3); }
	  ;

fun	: cpexpr EQ expr %prec LET	{ $$ = mkppat($1, $3); adderrinfo(leftmostid($1)); }
	  ;

apexpr	: id				{ $$ = mkident($1); } |
	  WILD				{ $$ = mkident("_"); } |
	  INTCONST			{ $$ = mkinteger($1); } |
	  MINUS INTCONST		{ $$ = mkinteger(-$2); } |
	  CHAR				{ $$ = mkcharr($1); } |
	  STRING			{ $$ = mkstring($1); } |
	  LPAR pexpr RPAR		{ $$ = mkpar($2); }	|
	  LBRACK pitems RBRACK		{ $$ = $2; } |
	  LBRACK RBRACK			{ $$ = niltree; }
	  ;

pexpr	: apexpr			{ $$ = $1; } |
	  pexpr COLON type		{ $$ = mkrestr($1, $3); } |
	  id AS pexpr			{ $$ = mkas($1, $3); } |
	  pexpr DOT pexpr		{ $$ = mkcons($1, $3); } |
	  pexpr pexpr %prec PREC_AP	{ $$ = mkap($1,$2); } |
	  pexpr INFIXL pexpr		{ $$ = mkbinop($2, $1, $3); } |
	  pexpr INFIXR pexpr		{ $$ = mkbinop($2, $1, $3); } |
	  PREFIX pexpr			{ $$ = mkunop($1, $2); } |
	  pexpr POSTFIX			{ $$ = mkunop($2, $1); } |
	  pexpr COMMA pexpr		{ if (ttree($3) == tuple)
						$$ = mktuple(mklcons($1, gtuplelist($3)));
					  else
						$$ = mktuple(ldub($1, $3));
					}
	  ;

cpexpr	: pexpr %prec PREC_AP		{ $$ = $1; } |
	  pexpr ANDOP LPAR expr RPAR	{ $$ = mkcondp($1, $4); }
	  ;

pitems	: pexpr SEMI pitems		{ $$ = mkcons($1, $3); } |
	  pexpr				{ $$ = mkcons($1, niltree); }
	  ;

atype	: ttid				{ $$ = mktname($1, Lnil); } |
	  LPAR type RPAR		{ $$ = $2; } |
	  typevar			{ $$ = $1; }
	  ;

type	: ttid types			{ $$ = mktname($1, $2); } |
	  atype				{ $$ = $1; } |
	  type TFUN type		{ $$ = mktname($2, ldub($1, $3)); } |
	  type INFIXL type		{ $$ = mktname($2, ldub($1, $3)); } |
	  type INFIXR type		{ $$ = mktname($2, ldub($1, $3)); } |
	  PREFIX type			{ $$ = mktname($1, lsing($2)); } |
	  type POSTFIX			{ $$ = mktname($2, lsing($1)); } |
	  atype TPAIR atype tpairs	{ $$ = mktname(installid(tupstr($4, 2)),
					mklcons($1, mklcons($3, $4))); }
	  ;

tpairs	: /* */				{ $$ = Lnil; } |
	  TPAIR atype tpairs		{ $$ = mklcons($2, $3); }
	  ;

types	: types atype			{ $$ = lapp($1, $2); } |
	  atype				{ $$ = lsing($1); }
	  ;

typevar	: TIMES ID			{ $$ = mktvar(typeno($2)); }
	  ;

ttid	: LPAR TFUN RPAR		{ $$ = $2; } |
	  LPAR TPAIR RPAR		{ $$ = "_#2"; } |
	  tid				{ $$ = $1; }
	  ;

tid	: ident				{ $$ = $1; } |
	  LPAR fixid RPAR		{ $$ = $2; } |
	  LPAR ident RPAR		{ $$ = $2; }
	  ;

constrs	: constrs PLUS constr		{ $$ = lapp($1, $3); } |
	  constr			{ $$ = lsing($1); }
	  ;

constr	: tid stypes			{ $$ = mkatc($1, $2); } |
	  stype INFIXL stype		{ $$ = mkatc($2, ldub($1, $3)); } |
	  stype INFIXR stype		{ $$ = mkatc($2, ldub($1, $3)); } |
	  PREFIX stype			{ $$ = mkatc($1, lsing($2)); } |
	  stype POSTFIX			{ $$ = mkatc($2, lsing($1)); } /*|
	  LPAR constr RPAR		{ $$ = $2; } */
	  ;

stypes	: /* empty */			{ $$ = Lnil; } |
	  stypes stype			{ $$ = lapp($1, $2); }
	  ;

stype	: atype				{ $$ = $1; } |
	  atype EXCL			{ $$ = mktstrict($1); }
	  ;

/*
finfo	: 			{ $$ = mknofinfo(); } |
	  LBRACE COMMA ID RBRACE	{ $$ = mkfinfo("_", $3, UFRS); } |
	  LBRACE ID COMMA ID RBRACE	{ $$ = mkfinfo($2, $4, UFRS); } |
	  LBRACE COMMA ID COMMA intconst RBRACE	{ $$ = mkfinfo("_", $3, $5); } |
	  LBRACE ID COMMA ID COMMA intconst RBRACE	{ $$ = mkfinfo($2, $4, $6); }
	  ;
intconst: INTCONST			{ $$ = $1; } |
	  MINUS INTCONST		{ $$ = -$2; }
	  ;

*/
finfo	: /* missing */			{ $$ = mknofinfo(); } |
	  ANNOT				{ $$ = finfofromstring($1); }
	  ;

ident	: ID				{ $$ = $1; } |
	  NONFIX			{ $$ = $1; }
	  ;

annot	: ANNOT				{ $$ = $1; }
	  ;

%%

finfot
finfofromstring(s)
char *s;
{
    char args[100], res[10];
    int frs;

    args[0] = res[0] = '_';
    if (sscanf(s, ",%[TF],%d", res+1, &frs) == 2) {
	return mkfinfo("_", installid(res), frs);
    } else if (sscanf(s, "%[TF],%[TF],%d", args+1, res+1, &frs) == 3) {
	return mkfinfo(installid(args), installid(res), frs);
    } else if (sscanf(s, ",%[TF]", res+1) == 1) {
	return mkfinfo("_", installid(res), UFRS);
    } else if (sscanf(s, "%[TF],%[TF]", args+1, res+1) == 2) {
	return mkfinfo(installid(args), installid(res), UFRS);
    } else {
	return mknofinfo();
    }
}
