--
-- $Header: /ufs/usr.src/local/lml/src/transform/RCS/match.m,v 2.22 87/05/25 17:26:33 augustss Exp $
--
module -- match
--
-- remove all pattern matching
--
#include "../expr/types.t.t"
#include "../expr/pprint.t"
#include "../misc/misc.t"
#include "../rename/multi.t"
#include "misc.t"
#include "case.t"
#include "lettrans.t"

export remmatch;
rec
    multielim p e =
      andify (map (\i.let ei=mkident i in mkbpat [(ei, pselect e ei p)]) (getids p))
and matchp fn (mkcondp p c) u =
	let (nc, u1) = match fn c u in (mkcondp p nc, u1)
||  matchp _ p u = (p, u)
and match fn e u =
	case e in
	   mkap f a :
		let (f1, u1) = match fn f u in
		let (a1, u2) = match fn a u1 in
		(mkap f1 a1, u2)
	|| mklam i e :	Uap (\e1.mklam i e1) (match fn e u)
	|| mkcase e pl :
		let (e1, u1) = match fn e u in
		let (pl1, u2) = Umap (\(p, e).\u.
			let (np, u1) = matchp fn p u in
			let (ne, u2) = match fn e u1 in
			(np, ne),u2) pl u1 in
		caseelim fn (mkcase e1 pl1) u2
	|| mkletv b e :
		let (b1, u1) = matchbind fn b u in
		let (e1, u2) = match fn e u1 in
		(mkletv b1 e1, u2)
	|| mkident _ : (e, u)
	|| mkmodule i fs is es b : Uap (mkmodule i fs is es) (matchbind fn b u)
	|| mkerror _ : (e, u)
	|| mkconstr c el : Uap (mkconstr c) (Umap (match fn) el u)
	|| mkinfo t e : Uap (mkinfo t) (match fn e u)
	-- mkconst, mkas, mkcondp, mkfailmatch cannot occur
	end
and
    matchbind fn b u =
	case b in
	   mkband b1 b2 :
		let (b11, u1) = matchbind fn b1 u in
		let (b21, u2) = matchbind fn b2 u1 in
		(mkband b11 b21, u2)
	|| mkbrec b : Uap mkbrec (matchbind fn b u)
	|| mkbmulti p e : matchbind "?" (multielim p e) u
	|| mkbpat [(i, e)] : Uap (\e1.mkbpat [(i, e1)]) (match (ppr i) e u)
	|| mkberror _ : (b, u)
	|| mkbnull : (b, u)
	|| mkblocal b1 b2 :
		let (b11, u1) = matchbind fn b1 u in
		let (b21, u2) = matchbind fn b2 u1 in
		(mkblocal b11 b21, u2)
	|| (b as (mkbtype _ _ _)) : (b, u)
	end
and remmatch e u = match "?" e u
end
